/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Iterator;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.util.DebugState;
import progress.message.util.SubjectCache;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.SearchResults;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectTable;
import progress.message.zclient.SubjectUtil;

public class SubjectSpace
extends DebugObject {
    private SubjectCache m_subjectCache;
    static int SCODE_ISYS = SubjectUtil.computeSCode("$ISYS", 0, "$ISYS".length());
    protected SubjectTable m_subjectTable = new SubjectTable();
    private long m_cacheVersion = 0L;

    public SubjectSpace(int initialCapacity, int maxEntries) {
        super(DebugState.GLOBAL_DEBUG_ON ? "SubjectSpace" : null);
        this.m_subjectCache = new SubjectCache(initialCapacity, maxEntries);
    }

    protected void resetCache() {
        this.m_subjectCache.clear();
        this.m_cacheVersion = 0L;
    }

    protected final void incrementCacheVersion() {
        if (this.m_cacheVersion == Long.MAX_VALUE) {
            this.m_cacheVersion = 0L;
            this.resetCache();
        } else {
            ++this.m_cacheVersion;
        }
    }

    public final void put(String subject, ISubjectMatchObject object) throws EInvalidSubjectSyntax {
        this.put(new Subject(subject), object);
    }

    public final synchronized void put(ISubject subject, ISubjectMatchObject object) throws EInvalidSubjectSyntax {
        if (subject.isMultiSubject()) {
            if (object.localEffect()) {
                this.onAddMultiSubjectObject(object);
            }
            Iterator<ISubject> subs = subject.getMultiSubjects();
            boolean cacheValid = true;
            while (subs.hasNext()) {
                ISubject s = subs.next();
                if (!this.m_subjectTable.put(s, object)) continue;
                cacheValid = false;
            }
            this.checkInvalidateCache(cacheValid);
        } else if (this.m_subjectTable.put(subject, object)) {
            this.resetCache();
        } else {
            this.incrementCacheVersion();
        }
        subject.saveMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get(ISubject subject, SearchResults result) {
        result.setSubject(subject);
        if (subject.isMultiSubject()) {
            long cacheVersion;
            boolean cacheHit = true;
            SearchResults r = null;
            Object object = this;
            synchronized (object) {
                r = (SearchResults)this.m_subjectCache.get(subject);
                if (r == null) {
                    if (this.DEBUG) {
                        this.debug("CACHE MISS for: " + subject);
                    }
                    cacheHit = false;
                    Iterator<ISubject> i = subject.getMultiSubjects();
                    r = result.newResults();
                    while (i.hasNext()) {
                        ISubject s = i.next();
                        this.getInternal(s, r, true);
                    }
                    this.m_subjectCache.put(subject.protectedClone(), r);
                } else if (this.DEBUG) {
                    this.debug("CACHE HIT for: " + subject);
                }
                cacheVersion = this.m_cacheVersion;
            }
            object = r;
            synchronized (object) {
                r.traversalComplete(cacheVersion);
                if (this.DEBUG) {
                    System.out.println("Got MultiSubject result" + (cacheHit ? " FROM CACHE: " : "NOT FROM CACHE:") + r.toString());
                }
                r.copyInto(null, result, cacheHit);
            }
            if (this.DEBUG) {
                this.debug("Copied MultiSubject result" + (cacheHit ? " FROM CACHE: " : ":") + result.toString());
            }
        } else {
            this.getInternal(subject, result, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getInternal(ISubject subject, SearchResults result, boolean multi) {
        long cacheVersion;
        if (!multi && subject.isReply() || subject.isHttpReply()) {
            if (this.DEBUG) {
                this.debug("Matching reply = " + subject);
            }
            this.m_subjectTable.get(subject, result);
            result.traversalComplete(Long.MAX_VALUE);
            subject.saveMemory();
            return;
        }
        SearchResults r = null;
        boolean cacheHit = true;
        Object object = this;
        synchronized (object) {
            r = (SearchResults)this.m_subjectCache.get(subject);
            if (r == null) {
                cacheHit = false;
                r = result.newResults();
                if (multi) {
                    r.setSearchParent(result);
                }
                r.setSubject(subject);
                if (this.DEBUG) {
                    System.out.println("Cache miss for: " + subject);
                }
                this.m_subjectTable.get(subject, r);
                this.m_subjectCache.put(subject, r);
            }
            cacheVersion = this.m_cacheVersion;
        }
        if (this.DEBUG) {
            this.debug((cacheHit ? "Got " : "Did NOT get ") + "cache hit for " + subject);
        }
        if (this.DEBUG && !subject.isSystem() && !subject.isSonicMQSubject()) {
            System.out.println((cacheHit ? "Got " : "Did NOT get ") + "cache hit for " + subject);
        }
        subject.saveMemory();
        object = r;
        synchronized (object) {
            r.traversalComplete(cacheVersion);
            if (this.DEBUG) {
                this.debug("Got result" + (cacheHit ? " FROM CACHE: " : ":") + r.toString());
            }
            r.copyInto(subject, result, cacheHit);
        }
        if (this.DEBUG) {
            this.debug("Copied result" + (cacheHit ? " FROM CACHE: " : ":") + result.toString());
        }
    }

    public final void removeSubjectObject(String subject, ISubjectMatchObject value) {
        this.removeSubjectObject(new Subject(subject), value);
    }

    public final synchronized void removeSubjectObject(ISubject subject, ISubjectMatchObject value) {
        if (subject.isMultiSubject()) {
            if (value.localEffect()) {
                this.onRemoveMultiSubjectObject(value);
            }
            Iterator<ISubject> subs = subject.getMultiSubjects();
            boolean cacheValid = true;
            while (subs.hasNext()) {
                ISubject s = subs.next();
                if (!this.m_subjectTable.removeSubjectObject(s, value)) continue;
                cacheValid = false;
            }
            this.checkInvalidateCache(cacheValid);
        } else if (this.m_subjectTable.removeSubjectObject(subject, value)) {
            this.resetCache();
        } else {
            this.incrementCacheVersion();
        }
    }

    private void checkInvalidateCache(boolean cacheValid) {
        if (!cacheValid) {
            this.resetCache();
        } else {
            this.incrementCacheVersion();
        }
    }

    protected void onAddMultiSubjectObject(ISubjectMatchObject o) {
    }

    protected void onRemoveMultiSubjectObject(ISubjectMatchObject o) {
    }
}

