/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import progress.message.jimpl.Message;
import progress.message.jimpl.Session;
import progress.message.jimpl.SessionAcknowledgeQueue;
import progress.message.zclient.Envelope;
import progress.message.zclient.MessageHandler;

public class SessionAcknowledgeProcessor
extends Thread {
    SessionAcknowledgeQueue m_msgQueue;
    Session m_jsession;
    progress.message.zclient.Session m_ackSession;
    MessageHandler m_zmessageHandler;

    public SessionAcknowledgeProcessor(Session session) {
        super("Session Acknowledge Thread");
        this.m_jsession = session;
        this.m_msgQueue = session.getAcknowledgeQueue();
    }

    @Override
    public void run() {
        if (this.m_msgQueue == null) {
            return;
        }
        while (!Thread.interrupted()) {
            try {
                Message msg;
                if (this.m_jsession.isClosing() || (msg = this.m_msgQueue.nextMessage()) == null) break;
                this.m_zmessageHandler = msg.getConsumer().getZmessageHandler();
                this.m_ackSession = this.m_zmessageHandler.getSession();
                Envelope env = msg.getEnvelope();
                if (!msg.getConsumer().isClosing() && !this.m_ackSession.isClosing()) {
                    this.m_ackSession.acknowledge(env);
                    env.handlerDone(this.m_zmessageHandler.isGuaranteed());
                }
                SessionAcknowledgeProcessor.yield();
            }
            catch (Exception exception) {}
        }
    }
}

