/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.strm;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.util.BufferSizeManager;
import com.sonicsw.blackbird.evs.nio.nwlink.util.SelectableNetworkLinkResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;

public class EvsInputStream
extends InputStream {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PERFORMANCE = false;
    private static final boolean DEBUG_BYTES = false;
    private final IEvsNetworkLink m_link;
    private final SelectableNetworkLinkResult m_netResult;
    private final Selector m_selector;
    private final boolean m_isBlocking;
    private final BufferSizeManager m_bufMan;
    private final boolean m_resizeBuf;
    private ByteBuffer m_currentBuffer;
    private final boolean m_buffered;
    private final ByteBuffer m_singleByteBuffer;

    public EvsInputStream(IEvsNetworkLink link, int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        this(null, null, link, maxBufferSize, minBufferSize, initialBufferSize);
    }

    private EvsInputStream(EvsInputStream parent, Selector selector, IEvsNetworkLink link, int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        this.m_link = link;
        this.m_netResult = parent != null ? parent.m_netResult : new SelectableNetworkLinkResult();
        this.m_isBlocking = this.m_link.isBlocking();
        this.m_selector = selector == null ? (!this.m_isBlocking ? Selector.open() : null) : selector;
        boolean bl = this.m_buffered = maxBufferSize > 0;
        if (this.m_buffered) {
            this.m_bufMan = new BufferSizeManager(4096, 1.0E-4f, maxBufferSize, minBufferSize, initialBufferSize, 2);
            if (minBufferSize < maxBufferSize) {
                this.m_resizeBuf = true;
                this.m_currentBuffer = ByteBuffer.allocateDirect(this.m_bufMan.getBufferSize());
            } else {
                this.m_resizeBuf = false;
                this.m_currentBuffer = ByteBuffer.allocateDirect(maxBufferSize);
            }
            this.m_singleByteBuffer = null;
            this.m_currentBuffer.limit(0);
        } else {
            this.m_bufMan = null;
            this.m_resizeBuf = false;
            this.m_singleByteBuffer = ByteBuffer.allocateDirect(1);
        }
    }

    public EvsInputStream createBufferedStream(int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        if (this.m_buffered) {
            return this;
        }
        EvsInputStream ret = new EvsInputStream(this, this.m_selector, this.m_link, maxBufferSize, minBufferSize, initialBufferSize);
        return ret;
    }

    @Override
    public final void close() throws IOException {
        if (!this.m_isBlocking) {
            this.m_selector.close();
        }
    }

    @Override
    public final int read() throws IOException {
        if (!this.m_buffered) {
            this.m_singleByteBuffer.clear();
            int c = this.readFromLink(this.m_singleByteBuffer);
            if (c > 0) {
                this.m_singleByteBuffer.flip();
                return this.m_singleByteBuffer.get();
            }
            return -1;
        }
        int ret = 0;
        this.fill(1);
        if (this.m_currentBuffer.remaining() == 0) {
            return -1;
        }
        return ret |= 0xFF & this.m_currentBuffer.get();
    }

    @Override
    public final int read(byte[] byteArray) throws IOException {
        return this.read(byteArray, 0, byteArray.length);
    }

    @Override
    public final int read(byte[] byteArray, int offset, int countParam) throws IOException {
        int count = countParam;
        if (!this.m_buffered) {
            return this.readFromLink(ByteBuffer.wrap(byteArray, offset, count));
        }
        int origOffset = offset;
        int preBuffered = this.m_currentBuffer.remaining();
        if (preBuffered > 0) {
            if (this.m_currentBuffer.remaining() >= count) {
                this.m_currentBuffer.get(byteArray, offset, count);
                return count;
            }
            if (preBuffered > 0) {
                this.m_currentBuffer.get(byteArray, offset, preBuffered);
                offset += preBuffered;
                count -= preBuffered;
            }
        }
        if (count >= this.m_bufMan.getBufferSize()) {
            int read = this.readFromLink(ByteBuffer.wrap(byteArray, offset, count));
            if (read == -1 && preBuffered > 0) {
                return preBuffered;
            }
            return read + preBuffered;
        }
        this.fill(count);
        if (!this.m_currentBuffer.hasRemaining()) {
            if (preBuffered > 0) {
                return preBuffered;
            }
            return -1;
        }
        int bytesToCopy = this.m_currentBuffer.remaining() < count ? this.m_currentBuffer.remaining() : count;
        this.m_currentBuffer.get(byteArray, offset, bytesToCopy);
        return bytesToCopy + preBuffered;
    }

    private final int readFromLink(ByteBuffer b) throws IOException {
        int ret = 0;
        try {
            int available = b.remaining();
            if (!this.m_isBlocking) {
                this.m_netResult.blockingOps = 0;
                while (ret <= 0) {
                    int read = this.m_link.read(b, this.m_netResult);
                    if (read == -1) {
                        if (ret == 0) {
                            ret = -1;
                        }
                    } else if (read > 0) {
                        ret += read;
                    } else {
                        if (read != 0) continue;
                        if (ret <= 0) {
                            try {
                                this.m_netResult.select(this.m_selector, false);
                                continue;
                            }
                            catch (ClosedSelectorException cse) {
                                IOException ioe = new IOException(cse.getMessage());
                                ioe.initCause(cse);
                                throw ioe;
                            }
                        }
                    }
                    break;
                }
            } else {
                ret = this.m_link.read(b, this.m_netResult);
            }
            if (this.m_resizeBuf && available >= this.m_bufMan.getBufferSize()) {
                this.m_bufMan.updateDataSize(ret);
            }
            return ret;
        }
        catch (IOException e) {
            if (ret > 0) {
                return ret;
            }
            throw e;
        }
        catch (EEvsIOException eeioe) {
            if (ret > 0) {
                return ret;
            }
            Exception e = eeioe.getExtendedException();
            if (e != null && e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ioe = new IOException(eeioe.getMessage());
            ioe.initCause(eeioe);
            throw ioe;
        }
    }

    private final void fill(int needed) throws IOException {
        if (this.m_currentBuffer.remaining() < needed) {
            int targetPos;
            if (this.m_currentBuffer.remaining() == 0) {
                if (this.m_resizeBuf && this.m_bufMan.getBufferSize() != this.m_currentBuffer.capacity()) {
                    this.m_currentBuffer = ByteBuffer.allocateDirect(this.m_bufMan.getBufferSize());
                }
                this.m_currentBuffer.clear();
                this.m_currentBuffer.limit(0);
            }
            if ((targetPos = this.m_currentBuffer.position() + needed) > this.m_currentBuffer.capacity()) {
                targetPos = this.m_currentBuffer.capacity();
            }
            this.m_currentBuffer.mark();
            this.m_currentBuffer.position(this.m_currentBuffer.limit());
            this.m_currentBuffer.limit(this.m_currentBuffer.capacity());
            try {
                while (this.m_currentBuffer.position() < targetPos && this.readFromLink(this.m_currentBuffer) != -1) {
                }
            }
            finally {
                this.m_currentBuffer.limit(this.m_currentBuffer.position());
                this.m_currentBuffer.reset();
            }
        }
    }

    @Override
    public final int available() throws IOException {
        if (!this.m_buffered) {
            return 0;
        }
        return this.m_currentBuffer.remaining();
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public final void mark(int readLimit) {
        throw new UnsupportedOperationException("mark not supported.");
    }

    @Override
    public final long skip(long count) throws IOException {
        throw new UnsupportedOperationException("skip not supported.");
    }

    private final void debug(String str) {
        System.out.println(this + ": " + str);
    }
}

