/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.zclient.Envelope;

public class ObjectMessage
extends Message
implements progress.message.jclient.ObjectMessage {
    public ObjectMessage() {
        super((short)4);
    }

    ObjectMessage(Envelope envelope) {
        super(envelope);
    }

    @Override
    public void setObject(Serializable object) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("OBJ_MSG_READ_ONLY"));
        }
        try {
            if (this.m_zenvelope.getMessage().cap() != 0) {
                this.m_zenvelope.setMessage(new progress.message.zclient.Message());
            }
            this.m_zenvelope.getMessage().writeObject(object);
        }
        catch (IOException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public Serializable getObject() throws JMSException {
        try {
            if (this.m_zenvelope.getMessage().cap() == 0) {
                return null;
            }
            this.m_zenvelope.getMessage().gotoByte(0);
            return (Serializable)this.m_zenvelope.getMessage().readObjectMessage();
        }
        catch (IOException e) {
            MessageFormatException exc = new MessageFormatException(e.getMessage());
            exc.setLinkedException(e);
            throw exc;
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionUtil.createJMSException("Class not found: " + e.getMessage(), e);
        }
    }
}

