/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Principal;
import java.util.Properties;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocket;
import progress.message.net.tcp.AbstractTcpServerSocket;
import progress.message.net.tcp.ProgressTcpSocket;

public class ProgressTcpServerSocket
extends AbstractTcpServerSocket {
    public ProgressTcpServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        super(principal, port, backlog, bindAddr, properties);
    }

    @Override
    public ServerSocket openServerSocket(int port, int backlog, ProgressInetAddress bindAddr) throws IOException {
        Integer receiveBufSize;
        ServerSocket s = null;
        int receiveSize = 0;
        if (this.conn_properties != null && (receiveBufSize = (Integer)this.conn_properties.get("TCP_RECEIVE_BUFFER_SIZE")) != null) {
            receiveSize = receiveBufSize;
        }
        s = new ServerSocket(port, backlog, bindAddr == null ? null : bindAddr.getDelegateInetAddress());
        return s;
    }

    @Override
    protected ProgressSocket createProgressSocket(Socket s) throws IOException {
        return new ProgressTcpSocket(s);
    }
}

