/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import progress.message.jclient.AbstractJMSContext;
import progress.message.jclient.DeliveryMode;
import progress.message.jclient.JMSExceptionUtils;
import progress.message.util.StringUtil;

public class JMSProducer
implements javax.jms.JMSProducer {
    private static final String MESSAGE_DESTINATION_MUST_BE_SET = "Destination must be set";
    private static final String MESSAGE_INVALID_PROPERTY_NAME = "Invalid property name";
    private static final String MESSAGE_INVALID_OBJECT_TYPE = "Invalid object type";
    private static final String MESSAGE_WAS_NULL = "Message was null";
    private static final String MESSAGE_INVALID_DELIVERY_MODE = "Invalid delivery mode";
    private static final String MESSAGE_INVALID_PRIORITY = "Invalid priority";
    private static final int OFFSET_ZERO = 0;
    private static final int LENGTH_ZERO = 0;
    private static final int PRIORITY_MIN = 0;
    private final AbstractJMSContext context;
    private final MessageProducer producer;
    private final Properties properties = new Properties();
    private CompletionListener completionListener;
    private Destination jmsHeaderReplyTo;
    private String jmsHeaderCorrelationID;
    private byte[] jmsHeaderCorrelationIDAsBytes;
    private String jmsHeaderType;

    public JMSProducer(AbstractJMSContext context, MessageProducer producer) {
        this.context = context;
        this.producer = producer;
    }

    private JMSProducer sendInternal(Destination destination, Message message) {
        if (message == null) {
            throw new MessageFormatRuntimeException(MESSAGE_WAS_NULL);
        }
        try {
            if (this.jmsHeaderCorrelationID != null) {
                message.setJMSCorrelationID(this.jmsHeaderCorrelationID);
            }
            if (this.jmsHeaderCorrelationIDAsBytes != null && this.jmsHeaderCorrelationIDAsBytes.length > 0) {
                message.setJMSCorrelationIDAsBytes(this.jmsHeaderCorrelationIDAsBytes);
            }
            if (this.jmsHeaderReplyTo != null) {
                message.setJMSReplyTo(this.jmsHeaderReplyTo);
            }
            if (this.jmsHeaderType != null) {
                message.setJMSType(this.jmsHeaderType);
            }
            this.setProperties(message);
            if (this.completionListener != null) {
                this.producer.send(destination, message, this.completionListener);
            } else {
                this.producer.send(destination, message);
            }
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    private void setProperties(Message message) throws JMSException {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            message.setObjectProperty(key.toString(), value);
        }
    }

    private void checkDestination(Destination destination) {
        if (destination == null) {
            throw new InvalidDestinationRuntimeException(MESSAGE_DESTINATION_MUST_BE_SET);
        }
    }

    @Override
    public JMSProducer send(Destination destination, Message message) {
        this.validateBeforeSend(destination);
        return this.sendInternal(destination, message);
    }

    private void validateBeforeSend(Destination destination) {
        this.checkDestination(destination);
        this.context.checkNotClosed();
    }

    @Override
    public JMSProducer send(Destination destination, String body) {
        this.validateBeforeSend(destination);
        TextMessage message = this.context.createTextMessage(body);
        return this.sendInternal(destination, message);
    }

    @Override
    public JMSProducer send(Destination destination, Map<String, Object> body) {
        this.validateBeforeSend(destination);
        MapMessage message = this.context.createMapMessage();
        if (body != null) {
            try {
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String name = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        message.setString(name, (String)value);
                        continue;
                    }
                    if (value instanceof Long) {
                        message.setLong(name, (Long)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        message.setDouble(name, (Double)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        message.setInt(name, (Integer)value);
                        continue;
                    }
                    if (value instanceof Character) {
                        message.setChar(name, ((Character)value).charValue());
                        continue;
                    }
                    if (value instanceof Short) {
                        message.setShort(name, (Short)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        message.setBoolean(name, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Float) {
                        message.setFloat(name, ((Float)value).floatValue());
                        continue;
                    }
                    if (value instanceof Byte) {
                        message.setByte(name, (Byte)value);
                        continue;
                    }
                    if (value instanceof byte[]) {
                        byte[] array = (byte[])value;
                        message.setBytes(name, array, 0, array.length);
                        continue;
                    }
                    message.setObject(name, value);
                }
            }
            catch (JMSException e) {
                throw JMSExceptionUtils.convertToRuntimeException(e);
            }
        }
        return this.sendInternal(destination, message);
    }

    @Override
    public JMSProducer send(Destination destination, byte[] body) {
        this.validateBeforeSend(destination);
        BytesMessage message = this.context.createBytesMessage();
        if (body != null) {
            try {
                message.writeBytes(body);
            }
            catch (JMSException e) {
                throw JMSExceptionUtils.convertToRuntimeException(e);
            }
        }
        return this.sendInternal(destination, message);
    }

    @Override
    public JMSProducer send(Destination destination, Serializable body) {
        this.validateBeforeSend(destination);
        ObjectMessage message = this.context.createObjectMessage(body);
        return this.sendInternal(destination, message);
    }

    @Override
    public JMSProducer setDisableMessageID(boolean value) {
        this.context.checkNotClosed();
        try {
            this.producer.setDisableMessageID(value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean getDisableMessageID() {
        this.context.checkNotClosed();
        try {
            return this.producer.getDisableMessageID();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setDisableMessageTimestamp(boolean value) {
        this.context.checkNotClosed();
        try {
            this.producer.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        this.context.checkNotClosed();
        try {
            return this.producer.getDisableMessageTimestamp();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setDeliveryMode(int deliveryMode) {
        if (!JMSProducer.isValidDeliveryMode(deliveryMode)) {
            throw new JMSRuntimeException(MESSAGE_INVALID_DELIVERY_MODE);
        }
        this.context.checkNotClosed();
        try {
            this.producer.setDeliveryMode(deliveryMode);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    private static boolean isValidDeliveryMode(int deliveryMode) {
        return deliveryMode == 1 || deliveryMode == 2 || deliveryMode == DeliveryMode.DISCARDABLE || deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED;
    }

    @Override
    public int getDeliveryMode() {
        this.context.checkNotClosed();
        try {
            return this.producer.getDeliveryMode();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setPriority(int priority) {
        if (priority < 0 || priority > 12) {
            throw new JMSRuntimeException(MESSAGE_INVALID_PRIORITY);
        }
        this.context.checkNotClosed();
        try {
            this.producer.setPriority(priority);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    @Override
    public int getPriority() {
        this.context.checkNotClosed();
        try {
            return this.producer.getPriority();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setTimeToLive(long timeToLive) {
        this.context.checkNotClosed();
        try {
            this.producer.setTimeToLive(timeToLive);
            return this;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public long getTimeToLive() {
        this.context.checkNotClosed();
        try {
            long timeToLive = this.producer.getTimeToLive();
            return timeToLive;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.context.checkNotClosed();
        try {
            this.producer.setDeliveryDelay(deliveryDelay);
            return this;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public long getDeliveryDelay() {
        this.context.checkNotClosed();
        try {
            return this.producer.getDeliveryDelay();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setAsync(CompletionListener completionListenerParam) {
        this.context.checkNotClosed();
        this.completionListener = completionListenerParam;
        return this;
    }

    @Override
    public CompletionListener getAsync() {
        this.context.checkNotClosed();
        return this.completionListener;
    }

    private void validatePropertyName(String propertyName) {
        if (StringUtil.isNullOrEmpty(propertyName)) {
            throw new IllegalArgumentException(MESSAGE_INVALID_PROPERTY_NAME);
        }
    }

    @Override
    public JMSProducer setProperty(String name, boolean value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, (Object)value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, byte value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, (Object)value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, short value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, (Object)value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, int value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, (Object)value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, long value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, (Object)value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, float value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, Float.valueOf(value));
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, double value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, (Object)value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, String value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        this.properties.put(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, Object value) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        if (!this.isValidPropertyType(value)) {
            throw new MessageFormatRuntimeException(MESSAGE_INVALID_OBJECT_TYPE);
        }
        this.properties.put(name, value);
        return this;
    }

    private boolean isValidPropertyType(Object value) {
        return value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String;
    }

    @Override
    public JMSProducer clearProperties() {
        this.context.checkNotClosed();
        this.properties.clear();
        return this;
    }

    @Override
    public boolean propertyExists(String name) {
        this.context.checkNotClosed();
        return this.properties.containsKey(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Boolean.parseBoolean((String)rawValue);
        }
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Boolean.TYPE);
    }

    private JMSRuntimeException getInvalidConversionException(String propertyName, Class<?> fromClass, Class<?> toClass) {
        String message = "Property: " + propertyName + " cannot be converted from " + fromClass.getSimpleName() + " to " + toClass.getSimpleName();
        return new MessageFormatRuntimeException(message, Integer.toString(-2001));
    }

    @Override
    public byte getByteProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Byte.parseByte((String)rawValue);
        }
        if (rawValue instanceof Byte) {
            return (Byte)rawValue;
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Byte.TYPE);
    }

    @Override
    public short getShortProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Short.parseShort((String)rawValue);
        }
        if (rawValue instanceof Short) {
            return (Short)rawValue;
        }
        if (rawValue instanceof Byte) {
            return ((Byte)rawValue).shortValue();
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Short.TYPE);
    }

    @Override
    public int getIntProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Integer.parseInt((String)rawValue);
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        if (rawValue instanceof Short) {
            return ((Short)rawValue).intValue();
        }
        if (rawValue instanceof Byte) {
            return ((Byte)rawValue).intValue();
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Integer.TYPE);
    }

    @Override
    public long getLongProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Long.parseLong((String)rawValue);
        }
        if (rawValue instanceof Long) {
            return (Long)rawValue;
        }
        if (rawValue instanceof Byte) {
            return ((Byte)rawValue).longValue();
        }
        if (rawValue instanceof Short) {
            return ((Short)rawValue).longValue();
        }
        if (rawValue instanceof Integer) {
            return ((Integer)rawValue).longValue();
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Long.TYPE);
    }

    @Override
    public float getFloatProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Float.parseFloat((String)rawValue);
        }
        if (rawValue instanceof Float) {
            return ((Float)rawValue).floatValue();
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Float.TYPE);
    }

    @Override
    public double getDoubleProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue == null || rawValue instanceof String) {
            return Double.parseDouble((String)rawValue);
        }
        if (rawValue instanceof Float) {
            return ((Float)rawValue).doubleValue();
        }
        if (rawValue instanceof Double) {
            return (Double)rawValue;
        }
        throw this.getInvalidConversionException(name, rawValue.getClass(), Double.TYPE);
    }

    @Override
    public String getStringProperty(String name) {
        Object rawValue = this.validateAndRetrieveValue(name);
        if (rawValue instanceof byte[]) {
            throw this.getInvalidConversionException(name, rawValue.getClass(), String.class);
        }
        if (rawValue instanceof String || rawValue == null) {
            return (String)rawValue;
        }
        return rawValue.toString();
    }

    private Object validateAndRetrieveValue(String name) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        Object rawValue = this.properties.get(name);
        return rawValue;
    }

    @Override
    public Object getObjectProperty(String name) {
        this.context.checkNotClosed();
        this.validatePropertyName(name);
        return this.properties.get(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        this.context.checkNotClosed();
        return this.properties.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
    }

    @Override
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.context.checkNotClosed();
        if (correlationID == null || correlationID.length == 0) {
            throw new JMSRuntimeException("Please specify a non-zero length byte[]");
        }
        this.jmsHeaderCorrelationIDAsBytes = Arrays.copyOf(correlationID, correlationID.length);
        return this;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        this.context.checkNotClosed();
        return Arrays.copyOf(this.jmsHeaderCorrelationIDAsBytes, this.jmsHeaderCorrelationIDAsBytes.length);
    }

    @Override
    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.context.checkNotClosed();
        this.jmsHeaderCorrelationID = correlationID;
        return this;
    }

    @Override
    public String getJMSCorrelationID() {
        this.context.checkNotClosed();
        return this.jmsHeaderCorrelationID;
    }

    @Override
    public JMSProducer setJMSType(String type) {
        this.context.checkNotClosed();
        this.jmsHeaderType = type;
        return this;
    }

    @Override
    public String getJMSType() {
        this.context.checkNotClosed();
        return this.jmsHeaderType;
    }

    @Override
    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.context.checkNotClosed();
        this.jmsHeaderReplyTo = replyTo;
        return this;
    }

    @Override
    public Destination getJMSReplyTo() {
        this.context.checkNotClosed();
        return this.jmsHeaderReplyTo;
    }
}

