/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.util.VersionData;
import progress.message.zclient.IResumeCredentials;

public final class ClientConnectParms
implements IResumeCredentials,
Cloneable {
    static final byte CURRENT_VERSION = 4;
    private short m_version = (short)4;
    private long m_clientTransactionBufferSize;
    private long m_faultTolerantReconnectTimeout;
    private long m_initialConnectTimeout;
    private long m_resumeSocketId;
    private long m_clientResumeSeqNr;
    private String m_name;
    private short m_majorVersion;
    private byte m_minorVersion;
    private byte m_pointVersion;
    private int m_buildNumber;
    private short m_flags;
    public static final short BROKER_FC_EVENTS_MASK = 1;
    private int m_clientFCMonitorInterval = -999;

    public ClientConnectParms() {
    }

    public ClientConnectParms(long clientTransactionBufferSize, long faultTolerantReconnectTimeout, long resumeSocketId, long clientResumeSeqNr, int clientFCMonitorInterval) {
        this.m_clientTransactionBufferSize = clientTransactionBufferSize;
        this.m_faultTolerantReconnectTimeout = faultTolerantReconnectTimeout;
        this.m_resumeSocketId = resumeSocketId;
        this.m_clientResumeSeqNr = clientResumeSeqNr;
        this.m_name = "SonicMQ/Java";
        this.m_majorVersion = (short)14;
        this.m_minorVersion = 0;
        this.m_pointVersion = (byte)10;
        this.m_buildNumber = 697;
        this.m_flags = (short)(this.m_flags | 1);
        this.m_clientFCMonitorInterval = clientFCMonitorInterval;
    }

    public long getClientTransactionBufferSize() {
        return this.m_clientTransactionBufferSize;
    }

    public long getFaultTolerantReconnectTimeout() {
        return this.m_faultTolerantReconnectTimeout;
    }

    public long getInitialConnectTimeout() {
        return this.m_initialConnectTimeout;
    }

    @Override
    public long getResumeSocketId() {
        return this.m_resumeSocketId;
    }

    @Override
    public long getClientResumeSeqNr() {
        return this.m_clientResumeSeqNr;
    }

    public void setClientTransactionBufferSize(long clientTransactionBufferSize) {
        this.m_clientTransactionBufferSize = clientTransactionBufferSize;
    }

    public void setFaultTolerantReconnectTimeout(long faultTolerantReconnectTimeout) {
        this.m_faultTolerantReconnectTimeout = faultTolerantReconnectTimeout;
    }

    public void setInitialConnectTimeout(long initialConnectTimeout) {
        this.m_initialConnectTimeout = initialConnectTimeout;
    }

    public void setResumeSocketId(long resumeSocketId) {
        this.m_resumeSocketId = resumeSocketId;
    }

    public void setClientResumeSeqNr(long clientResumeSeqNr) {
        this.m_clientResumeSeqNr = clientResumeSeqNr;
    }

    public short getVersion() {
        return this.m_version;
    }

    public void setVersion(short vers) {
        this.m_version = vers;
    }

    public boolean supportsBrokerFcEvents() {
        return (this.m_flags & 1) > 0;
    }

    public int getClientFCMonitorInterval() {
        return this.m_clientFCMonitorInterval;
    }

    public void setClientFCMonitorInterval(int seconds) {
        this.m_clientFCMonitorInterval = seconds;
    }

    public static ClientConnectParms unserialize(DataInput in) throws IOException {
        ClientConnectParms parms = new ClientConnectParms();
        parms.m_version = in.readShort();
        parms.m_clientTransactionBufferSize = in.readLong();
        parms.m_faultTolerantReconnectTimeout = in.readLong();
        parms.m_resumeSocketId = in.readLong();
        parms.m_clientResumeSeqNr = in.readLong();
        if (parms.m_version >= 2) {
            parms.m_name = in.readUTF();
            parms.m_majorVersion = in.readShort();
            parms.m_minorVersion = in.readByte();
            parms.m_pointVersion = in.readByte();
            parms.m_buildNumber = in.readInt();
        }
        if (parms.m_version >= 3) {
            parms.m_flags = in.readShort();
        }
        if (parms.m_version >= 4) {
            parms.m_clientFCMonitorInterval = in.readInt();
        }
        return parms;
    }

    public void serialize(OutputStream os) throws IOException {
        StreamUtil.writeShort(this.m_version, os);
        StreamUtil.writeLong(this.m_clientTransactionBufferSize, os);
        StreamUtil.writeLong(this.m_faultTolerantReconnectTimeout, os);
        StreamUtil.writeLong(this.m_resumeSocketId, os);
        StreamUtil.writeLong(this.m_clientResumeSeqNr, os);
        if (this.m_version >= 2) {
            if (this.m_name == null) {
                StreamUtil.writeUTF("", os);
            } else {
                StreamUtil.writeUTF(this.m_name, os);
            }
            StreamUtil.writeShort(this.m_majorVersion, os);
            StreamUtil.writeByte(this.m_minorVersion, os);
            StreamUtil.writeByte(this.m_pointVersion, os);
            StreamUtil.writeInt(this.m_buildNumber, os);
        }
        if (this.m_version >= 3) {
            StreamUtil.writeShort(this.m_flags, os);
        }
        if (this.m_version >= 4) {
            StreamUtil.writeInt(this.m_clientFCMonitorInterval, os);
        }
    }

    public static ClientConnectParms unserialize(InputStream in) throws IOException {
        ClientConnectParms parms = new ClientConnectParms();
        parms.m_version = StreamUtil.readShort(in);
        parms.m_clientTransactionBufferSize = StreamUtil.readLong(in);
        parms.m_faultTolerantReconnectTimeout = StreamUtil.readLong(in);
        parms.m_resumeSocketId = StreamUtil.readLong(in);
        parms.m_clientResumeSeqNr = StreamUtil.readLong(in);
        if (parms.m_version >= 2) {
            parms.m_name = StreamUtil.readUTF(in);
            parms.m_majorVersion = StreamUtil.readShort(in);
            parms.m_minorVersion = StreamUtil.readByte(in);
            parms.m_pointVersion = StreamUtil.readByte(in);
            parms.m_buildNumber = StreamUtil.readInt(in);
        }
        if (parms.m_version >= 3) {
            parms.m_flags = StreamUtil.readShort(in);
        }
        if (parms.m_version >= 4) {
            parms.m_clientFCMonitorInterval = StreamUtil.readInt(in);
        }
        return parms;
    }

    public int length() {
        int size = 42;
        size = this.m_name != null ? (size += StringUtil.lengthUTF(this.m_name)) : (size += StringUtil.lengthUTF(""));
        size += 10;
        return size += 4;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Version=" + this.m_version);
        sb.append(",TX Buffer=" + this.m_clientTransactionBufferSize);
        sb.append(",FT Reconnect=" + this.m_faultTolerantReconnectTimeout);
        sb.append(",Init connect=" + this.m_initialConnectTimeout);
        sb.append(",Resume sockid=" + this.m_resumeSocketId);
        sb.append(",Resume seqnr=" + this.m_clientResumeSeqNr);
        sb.append(",Name=" + this.m_name);
        sb.append(",pdtVers= " + this.m_majorVersion + "." + this.m_minorVersion + "." + this.m_pointVersion + " B " + this.m_buildNumber);
        sb.append(",Flags=" + this.m_flags);
        sb.append(",FCMonitorInt=" + this.m_clientFCMonitorInterval);
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public VersionData getProductVersion() {
        if (this.m_majorVersion == 0) {
            return null;
        }
        return new VersionData(this.m_name, this.m_majorVersion, this.m_minorVersion, this.m_pointVersion, this.m_buildNumber);
    }
}

