/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.TextMessage;
import progress.message.jclient.MessagePart;
import progress.message.jclient.Part;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.msg.IErrorHandle;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.util.ArrayUtil;
import progress.message.util.WrappedDataInputStream;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Request;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.xonce.IMgramTraceHelper;

public class MgramTrace {
    private static byte[] _types = new byte[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 26, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 32, 23, 25, 33, 28, 24, 22, 29, 34, 27, 30, 31, 35, 36, 37, 38};
    private static final int CLIENT_HELLO_SUBTYPE = 1;
    private static final int BROKER_REDIRECTED_SUBTYPE = 9;
    private static String[] _subtypes = new String[]{"ZERO", "CLIENT_HELLO_SUBTYPE", "BROKER_HELLO_SUBTYPE", "CLIENT_ID_SUBTYPE", "CHALLENGE_1_SUBTYPE", "CHALLENGE_2_SUBTYPE", "RESPONSE_SUBTYPE", "SUCCESS_SUBTYPE", "SEC_DISABLED_SUBTYPE", "BROKER_REDIRECTED_SUBTYPE"};
    private static String[] _type_strings = new String[]{"TXN_FILE_EOF_MARKER", "ERROR", "PING", "CONNECT", "NORMAL", "ACK", "VERSION", "IB_CONVERT", "FLOW_CONTROL", "DISCONNECT", "TXN_REQUEST", "EXTENDED_TXN_REQUEST", "QUEUE_ACKFORWARD", "QUEUE_NORMAL", "QUEUE_GET", "QUEUE_ACK", "GR_CONVERT", "GR_ROUTEINFO", "BLOCK", "RESUME", "NACK", "FAILOVER_STATUS_NOTIFICATION", "CONNECTION_SYNC", "IDR", "OPERATION", "WINDOWED_TXN_ACK", "ACK_LIST", "STATE_EVENT", "FT_CONVERT", "DATABASE", "REPLICATION_REQUEST_REPLY", "BATCH", "QUEUE_OPEN_REMOTE_RECEIVER", "QUEUE_CLOSE_REMOTE_RECEIVER", "REPLICATED_MGRAM", "SPLIT_DELIVERY_ACK", "PTP_FLOW_CONTROL", "REPORT_FLOW_CONTROL"};
    private static Hashtable _string_to_type_table;
    private static Hashtable _type_table;
    private static volatile IMgramTraceHelper _helper;

    private static IMgramTraceHelper getMgramTraceHelper() throws Exception {
        if (_helper != null) {
            return _helper;
        }
        _helper = SessionConfig.IN_BROKER ? (IMgramTraceHelper)Class.forName("progress.message.broker.BrokerMgramTraceHelper").newInstance() : (IMgramTraceHelper)Class.forName("progress.message.zclient.xonce.ClientMgramTraceHelper").newInstance();
        return _helper;
    }

    public static byte stringToType(String s) {
        Byte b = (Byte)_string_to_type_table.get(s);
        if (b == null) {
            return -1;
        }
        return b;
    }

    public static String typeToString(byte b) {
        String s = (String)_type_table.get(new Byte(b));
        if (s == null) {
            s = Byte.toString(b);
        }
        return s;
    }

    public static void diagnose(String pre, BaseConnection c, IMgram m) {
        String s = MgramTrace.diagnosticString(pre, c, m, false);
        if (s != null) {
            System.out.println(s);
        }
    }

    public static void diagnose(String pre, BaseConnection c, IMgram m, boolean includeBody) {
        String s = MgramTrace.diagnosticString(pre, c, m, includeBody);
        if (s != null) {
            System.out.println(s);
        }
    }

    public static String subTypeString(IMgram m) {
        String result = "UNKNOWN";
        block0 : switch (m.getType()) {
            case 8: {
                ITXNRequestHandle han = m.getTXNRequestHandle();
                if (m.isReply()) break;
                result = m.getTXNRequestHandle().opStr();
                break;
            }
            case 26: {
                if (m.isReply()) break;
                result = m.getExtendedTXNRequestHandle().opStr();
                break;
            }
            case 1: {
                byte b = m.getRawBody()[0];
                if (b < 0 || b > _subtypes.length - 1) {
                    result = Integer.toString(b);
                    break;
                }
                result = _subtypes[b];
                break;
            }
            case 25: {
                int type = m.getOperationHandle().getOperationType();
                switch (type) {
                    case 13: {
                        result = "LBS_WITH_LOOKUP";
                        break block0;
                    }
                    case 14: {
                        result = "LBS_WITHOUT_LOOKUP";
                        break block0;
                    }
                }
                result = Integer.toString(type);
                break;
            }
        }
        return result;
    }

    public static String diagnosticString(IMgram m) {
        return MgramTrace.diagnosticString(null, null, m, false);
    }

    public static String diagnosticString(String pre, BaseConnection c, IMgram m) {
        return MgramTrace.diagnosticString(pre, c, m, false);
    }

    public static String diagnosticString(String pre, BaseConnection c, IMgram m, boolean includeBody) {
        String length;
        String routing;
        String msgBody;
        String msgProps;
        String pri;
        String secure;
        String succ;
        String reply;
        String tx;
        String guar;
        String typ;
        block92: {
            if (m == null) {
                return "null";
            }
            typ = MgramTrace.typeToString(m.getType());
            guar = "";
            tx = "";
            reply = "";
            succ = "";
            secure = "";
            pri = "";
            msgProps = "";
            msgBody = "";
            routing = null;
            length = "";
            int p = 0;
            block5 : switch (m.getType()) {
                case 0: {
                    reply = reply + MgramTrace.getRequestReplyDescription(c, m);
                    break;
                }
                case -1: {
                    IErrorHandle ehandle = m.getErrorHandle();
                    typ = typ + ",errcode=" + ehandle.getErrCode() + ",errinfo=" + ehandle.getErrInfo();
                    break;
                }
                case 37: {
                    IPTPFlowControlHandle phandle = m.getPTPFlowControlHandle();
                    typ = typ + ",subtype=" + MgramTrace.getPTPFlowControlSubtype(phandle.getSubType()) + ",dest:" + phandle.getFlowSubject().getSubjectString();
                    break;
                }
                case 6: {
                    IFlowControlHandle handle = m.getFlowControlHandle();
                    typ = typ + ",minpri=" + handle.getMinPriority();
                    break;
                }
                case 8: {
                    if (!m.isReply()) {
                        typ = typ + "=" + m.getTXNRequestHandle().summaryString();
                    } else {
                        byte[] pay = m.getRawBody();
                        short status = ArrayUtil.readShort(pay, 0);
                        int replyTracking = ArrayUtil.readInt(pay, 2);
                        typ = typ + "=" + replyTracking + ",status=" + status;
                    }
                    if (m.isGuarenteed()) {
                        guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    }
                    reply = MgramTrace.getRequestReplyDescription(c, m);
                    break;
                }
                case 26: {
                    if (!m.isReply()) {
                        typ = typ + "=" + m.getExtendedTXNRequestHandle().summaryString();
                    } else {
                        byte[] pay = m.getRawBody();
                        short status = ArrayUtil.readShort(pay, 0);
                        int replyTracking = ArrayUtil.readInt(pay, 2);
                        typ = typ + "=" + replyTracking + ",status=" + status;
                    }
                    if (m.isGuarenteed()) {
                        guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    }
                    reply = MgramTrace.getRequestReplyDescription(c, m);
                    break;
                }
                case 16: {
                    p = 0;
                    byte[] pay = m.getRawBody();
                    long code = ArrayUtil.readLong(pay, p);
                    typ = typ + ",subtype=" + code;
                    break;
                }
                case 7: {
                    if (!m.isGuarenteed()) break;
                    guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    break;
                }
                case 18: 
                case 19: {
                    reply = MgramTrace.getRequestReplyDescription(c, m);
                    typ = typ + "=" + m.getQueueFlowControlHandle().getFlowDestination();
                    break;
                }
                case 3: 
                case 14: {
                    typ = typ + "=" + m.getAckHandle().getTrackingNumber() + ":CLIENTID:" + m.getAckHandle().getClientID();
                    if (m.isGuarenteed()) {
                        guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    }
                    if (!m.hasTxn()) break;
                    tx = "TX=" + m.getTxnId();
                    break;
                }
                case 28: {
                    typ = typ + "=" + m.getAckListHandle().summaryString();
                    break;
                }
                case 20: {
                    typ = typ + "=" + m.getAckHandle().getTrackingNumber();
                    if (!m.isGuarenteed()) break;
                    guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    break;
                }
                case 4: {
                    typ = typ + "=Mgram=" + m.getVersion() + ",Session=" + m.getSessionVersion();
                    break;
                }
                case 21: {
                    typ = typ + "=" + m.getFailoverStatusNotificationHandle().summaryString();
                    break;
                }
                case 32: {
                    typ = typ + "=" + m.getConnectionSyncHandle().summaryString();
                    break;
                }
                case 1: {
                    typ = typ + "=" + MgramTrace.getConnectSubtype(m);
                    break;
                }
                case 23: {
                    typ = typ + "=" + m.getIDRHandle().summaryString();
                    break;
                }
                case 33: {
                    typ = typ + "=" + m.getWindowAckHandle().windowAckSummaryString();
                    break;
                }
                case 27: {
                    if (m.isGuarenteed()) {
                        guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    }
                    secure = "SECURE=" + MgramTrace.securitySummary(m);
                    pri = "PRI=" + m.getPriority();
                    if (m.hasTxn()) {
                        tx = "TX=" + m.getTxnId();
                    }
                    if (m.getBatchHandle().isAtomic()) {
                        typ = typ + "[ATOMIC]";
                    }
                    typ = typ + "=SIZE-" + m.getBatchHandle().getBatchSize();
                    Iterator it = m.getBatchHandle().getBatchIterator();
                    typ = typ + "=GUARS-";
                    while (it.hasNext()) {
                        IMgram m2 = (IMgram)it.next();
                        if (!m2.isGuarenteed()) continue;
                        typ = typ + m2.getGuarenteedTrackingNum() + ",";
                    }
                    break;
                }
                case 25: {
                    typ = typ + "[" + m.getOperationHandle().getOperationType() + "]";
                    try {
                        block30 : switch (m.getOperationHandle().getOperationType()) {
                            case 1: {
                                typ = typ + "=FIRST_MSG_NOTIFICATION-" + MgramTrace.getUserFromClientId(m.getPayloadInputStreamHandle().readLong());
                                break;
                            }
                            case 2: {
                                typ = typ + "=LAST_MSG_NOTIFICATION-" + MgramTrace.getUserFromClientId(m.getPayloadInputStreamHandle().readLong());
                                break;
                            }
                            case 3: {
                                typ = typ + "=SINGLE_TARGET_MSG:TARGET=" + MgramTrace.getUserFromClientId(m.getPayloadInputStreamHandle().readLong());
                                IMgram first = (IMgram)m.getOperationHandle().getMgramList().getFirst();
                                guar = MgramTrace.getGuarWithTrackingNum(first, guar);
                                succ = "SUCC=" + first.isSuccessor();
                                msgProps = MgramTrace.diagnosticString("Mgram 1", c, (IMgram)m.getOperationHandle().getMgramList().getFirst());
                                break;
                            }
                            case 13: 
                            case 14: {
                                typ = m.getOperationHandle().getOperationType() == 14 ? typ + "=OP_GROUP_SUBSCRIPTION_WITHOUT_LOOKUP" : typ + "=OP_GROUP_SUBSCRIPTION_WITH_LOOKUP";
                                guar = MgramTrace.getGuarWithTrackingNum(m, guar);
                                succ = "SUCC=" + m.isSuccessor();
                                pri = "PRI=" + m.getPriority();
                                typ = typ + ":" + MgramTrace.getLBSInfo(m);
                                IMgram first = (IMgram)m.getOperationHandle().getMgramList().getFirst();
                                if (first != null) {
                                    msgProps = MgramTrace.diagnosticString("Mgram 1", c, (IMgram)m.getOperationHandle().getMgramList().getFirst());
                                    break;
                                }
                                break block92;
                            }
                            case 20: {
                                typ = typ + "=REMOTE_RESTORE_PHASES_DONE-" + MgramTrace.getUserFromClientId(m.getPayloadInputStreamHandle().readLong());
                                break;
                            }
                            case 15: {
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                byte ver = di.readByte();
                                long user = di.readLong();
                                typ = typ + "=CWADS_PING-V" + ver + "," + MgramTrace.getUserFromClientId(user);
                                break;
                            }
                            case 16: {
                                typ = typ + "=CWADS_PING_REPLY:";
                                break;
                            }
                            case 17: {
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                byte ver = di.readByte();
                                byte phase = di.readByte();
                                typ = typ + "=CWADS_LIST_XFER_OP-Ver/Phase:" + ver + "/" + phase;
                                break;
                            }
                            case 18: {
                                typ = typ + "=CWADS_LIST_XFER_REPLY_OP";
                                break;
                            }
                            case 19: {
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                byte ver = di.readByte();
                                long user = di.readLong();
                                typ = typ + "=CWADS_INFO_OP-V" + ver + "," + MgramTrace.getUserFromClientId(user);
                                break;
                            }
                            case 12: {
                                typ = typ + "=DURABLE_TRACKING_MGRAM_OP";
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                try {
                                    byte ver = di.readByte();
                                    String tracking = di.readUTF();
                                    typ = typ + ",V=" + ver + ",Trk=" + tracking;
                                }
                                catch (IOException ver) {}
                                break;
                            }
                            case 26: {
                                typ = typ + "=QOP_UPDATE";
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                WrappedDataInputStream is = new WrappedDataInputStream(di);
                                int count = di.readShort();
                                for (int i = 0; i < count; ++i) {
                                    byte a = di.readByte();
                                    ISubject s = Subject.createFromStream(is);
                                    String qop = "[UNKNOWN";
                                    if (a == 0) {
                                        qop = "[NONE";
                                    } else if (a == 1) {
                                        qop = "[INTEGRITY";
                                    } else if (a == 2) {
                                        qop = "[PRIVACY";
                                    }
                                    typ = typ + qop + " for " + s.toString() + "]";
                                }
                                break block5;
                            }
                            case 30: {
                                typ = typ + "=REJECTION_ACK_OP";
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                try {
                                    String msg = "";
                                    if (di.readBoolean()) {
                                        typ = typ + ",msg=" + di.readUTF();
                                    }
                                    typ = typ + ",err=" + di.readInt();
                                }
                                catch (IOException msg) {
                                    // empty catch block
                                }
                                msgProps = MgramTrace.diagnosticString("Rejected Mgram", c, (IMgram)m.getOperationHandle().getMgramList().getFirst());
                                break;
                            }
                            case 31: {
                                typ = typ + "=DIAG_OP";
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                try {
                                    short operation = di.readShort();
                                    typ = typ + ",operation=" + operation;
                                }
                                catch (IOException operation) {}
                                break;
                            }
                            case 23: {
                                typ = typ + "=FT_OPERATION,SUBTYPE=";
                                guar = MgramTrace.getGuarWithTrackingNum(m, guar);
                                ObjectInput di = m.getPayloadInputStreamHandle();
                                byte version = di.readByte();
                                byte subType = di.readByte();
                                switch (subType) {
                                    case 1: {
                                        typ = typ + "END_SYNCPOINT";
                                        break block30;
                                    }
                                    case 5: {
                                        typ = typ + "TXN_SYNC_COMPLETE_OP";
                                        break block30;
                                    }
                                    case 2: {
                                        int tid = di.readInt();
                                        short flags = di.readShort();
                                        typ = typ + "REPLICATE_TXN_MGRAM:tid=" + tid + ":flags=" + flags;
                                        break block30;
                                    }
                                    case 3: {
                                        typ = typ + "USERIDMAPPING_SYNC_OP";
                                        break block30;
                                    }
                                    case 8: {
                                        typ = typ + "RBREGISTRY_SYNC_OP";
                                        break block30;
                                    }
                                    case 9: {
                                        typ = typ + "ROUTEINFOS_SYNC_OP";
                                        break block30;
                                    }
                                    case 4: {
                                        typ = typ + "SUBSCRIPTION_SYNC_OP";
                                        break block30;
                                    }
                                    case 6: {
                                        typ = typ + "REPLICATE_DUR_MGRAM_OP";
                                        break block30;
                                    }
                                    case 7: {
                                        typ = typ + "REPLICATE_DUP_DETECT_OP";
                                        break block30;
                                    }
                                    case 10: {
                                        typ = typ + "QUEUE_DYNAMIC_SYNC_DONE_OP";
                                        break block30;
                                    }
                                }
                                typ = typ + "UNKNOWN";
                            }
                        }
                    }
                    catch (IOException ioe) {
                        SessionConfig.logMessage("Error Tracing operation mgram!", ioe, SessionConfig.getLevelWarning());
                    }
                    break;
                }
                case 13: {
                    p = 0;
                    byte[] raw = m.getRawBody();
                    short getType = ArrayUtil.readShort(raw, p);
                    int preFetch = ArrayUtil.readInt(raw, p += 2);
                    String getTypeStr = getType == 2 ? "RCVNOWAIT" : "RCVWAIT";
                    typ = typ + ",subtype=" + getTypeStr + ",prefetch=" + preFetch;
                    break;
                }
                case 24: {
                    IStateEventHandle shandle = m.getStateEventHandle();
                    IStateEvent se = shandle.getStateEvent();
                    char[] flags = new char[]{se.canBeDelayed() ? (char)'D' : '-', se.isAction() ? (char)'A' : '-', se.mustBeBuffered() ? (char)'B' : '-', se.usesClientRegistry() ? (char)'C' : '-', se.usesSubscriptionTable() ? (char)'S' : '-', se.utilizeActionProcessor() ? (char)'P' : '-'};
                    typ = typ + ",state=" + se + ",flags=" + new String(flags);
                    break;
                }
                case 38: {
                    ObjectInput di = m.getPayloadInputStreamHandle();
                    try {
                        byte b1 = di.readByte();
                        byte b2 = di.readByte();
                        String string = (b1 == 2 ? ",GR" : ",") + (b2 == 1 ? "BLK" : "RES");
                    }
                    catch (IOException iOException) {}
                    break;
                }
                default: {
                    if (m.isGuarenteed()) {
                        guar = "GUAR=" + m.getGuarenteedTrackingNum();
                    }
                    if (m.supportsRouting() && m.getRoutingHandle() != null) {
                        routing = m.getRoutingHandle().getAllRoutingString();
                    }
                    if (m.getType() == 12 || m.getType() == 2) {
                        if (m.isJMSPersistent()) {
                            guar = guar + "[PERS]";
                        }
                        if (m.isDiscardable()) {
                            guar = guar + "[DISC]";
                        }
                        if (m.isNonPersistentReplicated()) {
                            guar = guar + "[NPR]";
                        }
                        length = "pLen: " + m.getPayloadLength() + ",bLen: " + m.getBodyLength();
                    }
                    reply = MgramTrace.getRequestReplyDescription(c, m);
                    succ = "SUCC=" + m.isSuccessor();
                    secure = "SECURE=" + MgramTrace.securitySummary(m);
                    pri = "PRI=" + m.getPriority();
                    if (m.hasTxn()) {
                        tx = "TX=" + m.getTxnId();
                    }
                    msgProps = MgramTrace.propsStr(m);
                }
            }
        }
        String sockStr = MgramTrace.getSocketId(c);
        String appstr = MgramTrace.getApplicationId(c, m) + "-" + MgramTrace.getUserId(c, m);
        String s = MgramTrace.getSubject(m);
        if (includeBody && (m.getType() == 12 || m.getType() == 2)) {
            msgBody = MgramTrace.bodyStr(m);
        }
        return pre + ":" + sockStr + ":" + appstr + ":" + typ + ":" + guar + ":" + tx + ":" + succ + ":" + pri + ":" + secure + ":" + reply + "::" + length + ":" + (routing != null ? routing + "::" : "") + s + ":" + msgProps + (msgBody.length() > 0 ? "\n" + msgBody : "");
    }

    private static String getGuarWithTrackingNum(IMgram m, String guarParam) {
        String guar = guarParam;
        if (m.isGuarenteed()) {
            guar = "GUAR=" + m.getGuarenteedTrackingNum();
        }
        return guar;
    }

    /*
     * Loose catch block
     */
    public static String bodyStr(IMgram m) {
        Object is = null;
        if (!m.hasBody() || !m.hasSidebandData()) {
            return "";
        }
        short mType = m.getSidebandData().getBodyType();
        if (mType == 7 || mType == 6) {
            byte[] body = m.getRawBody();
            Message zm = new Message(body);
            try {
                return zm.readUTF();
            }
            catch (Exception e) {
                return "BAD UTF FOR TEXT OR XML MESSAGE";
            }
        }
        if (mType == 1) {
            javax.jms.Message jmsMsg;
            block14: {
                String ext = (String)m.getSidebandData().getProperty("JMS_SonicMQ_ExtendedType");
                if (ext == null || !ext.equals("x-sonicmq-multipart")) {
                    return "";
                }
                MultipartMessage multiMessage = new MultipartMessage(new Envelope(new Message(m.getRawBody())));
                int count = multiMessage.getPartCount();
                if (count < 1) {
                    return "MULTIPART COUNT IS INVALID!";
                }
                Part part = multiMessage.getPart(0);
                if (!part.isMessagePart()) {
                    return new String(part.getContentBytes());
                }
                MessagePart mp = (MessagePart)part;
                jmsMsg = mp.getMessage();
                if (jmsMsg instanceof TextMessage) break block14;
                return "FIRST MESSAGE PART IS NOT A TEXT MESSAGE!";
                {
                    catch (Exception e) {
                        return "INVALID CONTENT";
                    }
                }
            }
            try {
                progress.message.jimpl.TextMessage textJmsMsg = (progress.message.jimpl.TextMessage)jmsMsg;
                byte[] body = textJmsMsg.getEnvelope().getMessage().getBody();
                Message zm = new Message(body);
                return zm.readUTF();
            }
            catch (Exception e) {
                return "INVALID FIRST MESSAGE PART BAD UTF!";
            }
        }
        if (mType == 2) {
            byte[] body = m.getRawBody();
            return new String(body);
        }
        return "";
    }

    public static String propsStr(IMgram m) {
        Hashtable props = null;
        String msgProps = "";
        if (m.hasSidebandData()) {
            props = m.getSidebandData().getProperties();
        }
        if (props != null && !props.isEmpty()) {
            Object val;
            Object key;
            Iterator i = props.keySet().iterator();
            if (i.hasNext()) {
                key = i.next();
                val = props.get(key);
                msgProps = msgProps + key + "=" + val;
            }
            while (i.hasNext()) {
                key = i.next();
                val = props.get(key);
                msgProps = msgProps + "," + key + "=" + val;
            }
        }
        return msgProps;
    }

    public static String getConnectSubtype(IMgram m) {
        byte b = m.getRawBody()[0];
        if (b < 0 || b > _subtypes.length - 1) {
            return Integer.toString(b);
        }
        if (b == 1) {
            return _subtypes[b] + MgramTrace.getExtendedHelloOptions(m);
        }
        if (b == 9) {
            return _subtypes[b] + MgramTrace.getRedirectUrls(m);
        }
        return _subtypes[b];
    }

    public static String getSocketId(BaseConnection c) {
        try {
            return MgramTrace.getMgramTraceHelper().getSocketId(c);
        }
        catch (Exception e) {
            return "???";
        }
    }

    public static String getRedirectUrls(IMgram m) {
        String res = "";
        try {
            if (m.getRawBody().length > 1) {
                ObjectInput dis = m.getPayloadInputStreamHandle();
                dis.readByte();
                res = ",url=" + dis.readUTF();
            }
        }
        catch (IOException ioe) {
            SessionConfig.logMessage("Error Tracing connect redirect mgram!", ioe, SessionConfig.getLevelWarning());
        }
        return res;
    }

    public static String getExtendedHelloOptions(IMgram m) {
        boolean lb = false;
        boolean lbdata = false;
        boolean cp = false;
        boolean ft = false;
        boolean recovery = false;
        String cparms = "";
        try {
            if (m.getRawBody().length > 2) {
                ObjectInput dis = m.getPayloadInputStreamHandle();
                dis.readByte();
                dis.readByte();
                short lflags = dis.readShort();
                lb = (lflags & 1) > 0;
                lbdata = (lflags & 8) > 0;
                ft = (lflags & 2) > 0;
                cp = (lflags & 0x10) > 0;
                boolean bl = recovery = (lflags & 4) > 0;
                if (lbdata) {
                    dis.readUTF();
                }
                if (cp) {
                    ClientConnectParms clientParameters = ClientConnectParms.unserialize(dis);
                    cparms = clientParameters.toString();
                }
            }
        }
        catch (IOException ioe) {
            SessionConfig.logMessage("Error Tracing operation mgram!", ioe, SessionConfig.getLevelWarning());
        }
        return ",lb=" + lb + ",ft=" + ft + ",resume=" + recovery + ",cparms=" + cparms;
    }

    public static String getApplicationId(BaseConnection c, IMgram m) {
        try {
            return MgramTrace.getMgramTraceHelper().getApplicationId(c, m);
        }
        catch (Exception e) {
            return "???";
        }
    }

    public static String getUserFromClientId(long id) {
        try {
            return MgramTrace.getMgramTraceHelper().getUserFromClientId(id);
        }
        catch (Exception e) {
            return "???";
        }
    }

    public static String getSubject(IMgram m) {
        String s = new String("");
        try {
            switch (m.getType()) {
                case 3: {
                    break;
                }
                default: {
                    s = m.getSubject().getSubjectString();
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s == null ? "" : s;
    }

    static String getUserId(BaseConnection bc, IMgram m) {
        try {
            return MgramTrace.getMgramTraceHelper().getUserId(bc, m);
        }
        catch (Exception e) {
            return "???";
        }
    }

    static String getLBSInfo(IMgram m) {
        try {
            return MgramTrace.getMgramTraceHelper().getLBSInfo(m);
        }
        catch (Exception e) {
            return "???";
        }
    }

    private static String getAssociatedRequestDescription(Connection c, long track) {
        Request r = c.getRequest(track);
        IMgram m = null;
        if (r != null) {
            m = r.getRequest().getMgram();
        }
        if (m == null) {
            return "";
        }
        return "," + m.getSubject();
    }

    private static String securitySummary(IMgram m) {
        StringBuffer sb = new StringBuffer();
        if (!m.isSecure()) {
            return "false";
        }
        byte sa = 0;
        try {
            sa = m.getSecurity();
        }
        catch (Throwable e) {
            return "??";
        }
        if (sa == 0) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append(SecurityLogic.isQuery(sa) ? "Q" : "NQ");
        sb.append(SecurityLogic.isSKeyDigest(sa) ? ",SD" : "");
        sb.append(SecurityLogic.isSKeyEncryption(sa) ? ",SE" : "");
        sb.append(SecurityLogic.isMKeyDigest(sa) ? ",MD" : "");
        sb.append(SecurityLogic.isMKeyMacHeader(sa) ? ",MM" : "");
        sb.append(SecurityLogic.isMKeyEncryption(sa) ? ",ME" : "");
        return sb.toString();
    }

    private static String getRequestReplyDescription(BaseConnection c, IMgram m) {
        String reqrep = "REQUEST/REPLY=";
        String reply = "";
        try {
            if (m.isReply()) {
                reqrep = "REPLY=";
                long replyTrack = (long)m.getReplyTracking() & 0xFFFFFFFFL;
                if (c instanceof Connection) {
                    reply = reqrep + replyTrack + MgramTrace.getAssociatedRequestDescription((Connection)c, replyTrack);
                }
            } else if (m.isRequest()) {
                reqrep = "REQUEST=";
                reply = reqrep + ((long)m.getReplyTracking() & 0xFFFFFFFFL);
            }
        }
        catch (Throwable t) {
            reply = reqrep + "???";
        }
        return reply;
    }

    private static String getPTPFlowControlSubtype(byte st) {
        switch (st) {
            case 1: {
                return "BLOCK";
            }
            case 2: {
                return "RESUME_BEGIN";
            }
            case 4: {
                return "RESUME_COMPLETE";
            }
            case 3: {
                return "RESUME_REPLY";
            }
        }
        return Byte.toString(st);
    }

    static {
        _helper = null;
        _type_table = new Hashtable();
        _string_to_type_table = new Hashtable();
        for (int i = 0; i < _types.length; ++i) {
            Byte b = new Byte(_types[i]);
            _type_table.put(b, _type_strings[i]);
            _string_to_type_table.put(_type_strings[i], b);
        }
    }
}

