/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import progress.message.broker.LogFilterSupport;
import progress.message.util.DebugFilterManager;
import progress.message.zclient.DebugMasks;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.MgramFilterSupport;

public class DebugState {
    private static volatile Hashtable<String, Integer> debug_tab;
    private static volatile Hashtable<String, String> debug_callbacks;
    public static boolean GLOBAL_DEBUG_ON;
    private static boolean DEBUG_THREAD_NAME;
    private static boolean DEBUG_CLASS_ON;
    private static boolean DEBUG_DIAG_ON;
    public static int debugDiagnosticLevel;
    private static int ALL_DIAGNOSTIC_LEVELS;
    private static String SONICMQ_DEBUG_SUBSYS;
    private static String NO_TRACING_MESSAGE;
    private static String[] OPERATIONS;
    private static HashMap<String, String> DESCRIBE_PARAM_DESCIPTOR;
    private static HashMap<String, String> UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR;
    private static HashMap<String, String> SHOW_TRACE_LEVEL_PARAM_DESCIPTOR;
    private static String TRACE_LEVEL_PARAM_DESCRIPTION;
    private static String DOI_ID_PARAM_DESCRIPTION;
    private static HashMap<String, HashMap<String, String>> PARAM_DESCRIPTOR;

    public static void parse(String s) {
        if (s != null) {
            DEBUG_CLASS_ON = true;
            GLOBAL_DEBUG_ON = DEBUG_CLASS_ON || DEBUG_DIAG_ON;
            debug_tab = new Hashtable();
            SessionConfig.logln("Parsing DEBUG_NAME=" + s);
            try {
                StringTokenizer stz = new StringTokenizer(s, ";");
                while (stz.hasMoreTokens()) {
                    String entry = stz.nextToken();
                    String filter = "";
                    int classFlags = -1;
                    int ix = entry.indexOf(":");
                    if (ix != -1) {
                        String value = entry.substring(ix + 1);
                        int indexStart = value.indexOf("[");
                        int indexEnd = value.indexOf("]");
                        if (-1 != indexStart && -1 != indexEnd) {
                            filter = value.substring(indexStart);
                            value = value.substring(0, indexStart);
                        } else if (-1 != indexStart || -1 != indexEnd) {
                            SessionConfig.logln("Please check the format of your filter");
                        }
                        if (!"".equals(value)) {
                            try {
                                classFlags = DebugMasks.adjustFlags(Integer.parseInt(value));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        entry = entry.substring(0, ix);
                    }
                    int indexStart = entry.indexOf("[");
                    int indexEnd = entry.indexOf("]");
                    if (-1 != indexStart && -1 != indexEnd) {
                        filter = entry.substring(indexStart);
                        entry = entry.substring(0, indexStart);
                    } else if (-1 != indexStart || -1 != indexEnd) {
                        SessionConfig.logln("Please check the format of your debug filter");
                    }
                    debug_tab.put(entry, classFlags);
                    if (filter.length() <= 0) continue;
                    DebugFilterManager.getInstance().resetFilterValues(entry);
                    DebugFilterManager.getInstance().parseFilterValue(entry, filter);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public static void parseCallbacks(String s) {
        if (s != null) {
            DEBUG_CLASS_ON = true;
            GLOBAL_DEBUG_ON = DEBUG_CLASS_ON || DEBUG_DIAG_ON;
            debug_callbacks = new Hashtable();
            try {
                StringTokenizer stz = new StringTokenizer(s, ";");
                while (stz.hasMoreTokens()) {
                    String entry = stz.nextToken();
                    String callbackClass = null;
                    int ix = entry.indexOf(":");
                    if (ix != -1) {
                        String value = entry.substring(ix + 1);
                        if (value.equals("")) continue;
                        callbackClass = value;
                        entry = entry.substring(0, ix);
                    }
                    debug_callbacks.put(entry, callbackClass);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public static boolean get(String s) {
        try {
            String temp = DebugState.getFirstToken(s);
            return debug_tab.containsKey(temp);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static String getCallback(String s) {
        String value = DebugState.getFirstToken(s);
        if (debug_callbacks == null) {
            return null;
        }
        return debug_callbacks.get(value);
    }

    public static int getDiagnosticFlags(String s) {
        if (DEBUG_CLASS_ON) {
            String temp = DebugState.getFirstToken(s);
            if (debug_tab != null) {
                Integer value = debug_tab.get(temp);
                if (value == null) {
                    return 0;
                }
                int flags = value;
                if (flags != -1) {
                    return flags;
                }
                if (DEBUG_DIAG_ON) {
                    return debugDiagnosticLevel;
                }
                return ALL_DIAGNOSTIC_LEVELS;
            }
            return 0;
        }
        if (DEBUG_DIAG_ON) {
            return debugDiagnosticLevel;
        }
        return 0;
    }

    public static String getFirstToken(String str) {
        int delimiter = 32;
        int cutoff = str.indexOf(delimiter);
        if (cutoff < 0) {
            String ret = str;
            return ret;
        }
        String ret = str.substring(0, cutoff);
        return ret;
    }

    public static void setDiagnosticLevel(int value) {
        debugDiagnosticLevel = DebugMasks.adjustFlags(value);
        if (value != 0) {
            DEBUG_DIAG_ON = true;
            GLOBAL_DEBUG_ON = DEBUG_CLASS_ON || DEBUG_DIAG_ON;
        }
    }

    public static void setDebugThreadName(boolean b) {
        DEBUG_THREAD_NAME = b;
    }

    public static boolean getDebugThreadName() {
        return DEBUG_THREAD_NAME;
    }

    public static void registerSonicDiagnostics() {
        DebugObjectDiagnostics diagnostics = new DebugObjectDiagnostics();
        diagnostics.register();
    }

    static {
        GLOBAL_DEBUG_ON = false;
        DEBUG_THREAD_NAME = false;
        DEBUG_CLASS_ON = false;
        DEBUG_DIAG_ON = false;
        ALL_DIAGNOSTIC_LEVELS = DebugMasks.adjustFlags(255);
        SONICMQ_DEBUG_SUBSYS = "sonic.mq.debug";
        NO_TRACING_MESSAGE = SONICMQ_DEBUG_SUBSYS + " has no tracing setup";
        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        SHOW_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        TRACE_LEVEL_PARAM_DESCRIPTION = "See progress.message.zclient.DebugMasks for details. Default is 0";
        DOI_ID_PARAM_DESCRIPTION = "Use to address a specific class or MQ subsystem. If not specified then addresses " + SONICMQ_DEBUG_SUBSYS + " globally";
        PARAM_DESCRIPTOR = new HashMap();
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("integerTraceLevel", TRACE_LEVEL_PARAM_DESCRIPTION);
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("doiID", DOI_ID_PARAM_DESCRIPTION);
        SHOW_TRACE_LEVEL_PARAM_DESCIPTOR.put("doiID", DOI_ID_PARAM_DESCRIPTION);
        PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("updateTraceLevel", UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("showTraceLevel", SHOW_TRACE_LEVEL_PARAM_DESCIPTOR);
        OPERATIONS = AbstractDiagnosticsProvider.toOpnameArray(PARAM_DESCRIPTOR);
    }

    static class DebugObjectDiagnostics
    extends AbstractDiagnosticsProvider {
        private static final String NOMATCH_FILTER = "type:NOMATCH,ltype:NOMATCH;;;action:print";
        private static final String SET_DEBUG_CALLBACK = "setDebugCallback";
        private static final String CLEAR_DEBUG_CALLBACK = "clearDebugCallback";
        private static final String SET_MGRAM_CALLBACK_FILTER = "setMgramCallbackFilter";
        private static final String CLEAR_MGRAM_CALLBACK_FILTER = "clearMgramCallbackFilter";
        private static final String SET_LOG_CALLBACK_FILTER = "setLogCallbackFilter";
        private static final String CLEAR_LOG_CALLBACK_FILTER = "clearLogCallbackFilter";
        private static final String MQ_DEBUG_HELP = "/com/sonicsw/sdf/text/sonic-mq-debug-help";
        private static final String SET_DEBUG_CALLBACK_HELP = "/com/sonicsw/sdf/text/set-debug-callback";
        private static final String CLEAR_DEBUG_CALLBACK_HELP = "/com/sonicsw/sdf/text/clear-debug-callback";
        private static final String SET_MGRAM_CALLBACK_FILTER_HELP = "/com/sonicsw/sdf/text/set-mgram-callback-filter";
        private static final String SET_LOG_CALLBACK_FILTER_HELP = "/com/sonicsw/sdf/text/set-log-callback-filter";

        DebugObjectDiagnostics() {
            super(SONICMQ_DEBUG_SUBSYS);
        }

        @Override
        public String describe() {
            StringBuffer tmp = new StringBuffer();
            this.printFromFileToBuffer(MQ_DEBUG_HELP, tmp);
            return tmp.toString();
        }

        @Override
        public String[] getOperations() {
            return OPERATIONS;
        }

        @Override
        public HashMap describeParameters(String operationName) {
            return (HashMap)PARAM_DESCRIPTOR.get(operationName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getDOInstances() {
            if (debug_tab == null) {
                return new String[0];
            }
            Hashtable hashtable = debug_tab;
            synchronized (hashtable) {
                ArrayList<String> list = new ArrayList<String>();
                Enumeration keys = debug_tab.keys();
                while (keys.hasMoreElements()) {
                    list.add((String)keys.nextElement());
                }
                String[] result = new String[list.size()];
                list.toArray(result);
                return result;
            }
        }

        @Override
        public void showTraceLevel(String doiID, HashMap parametersNotUsed, StringBuffer buffer) {
            if (!GLOBAL_DEBUG_ON) {
                buffer.append(NO_TRACING_MESSAGE);
                return;
            }
            if (doiID == null) {
                this.showAll(buffer);
                return;
            }
            if (debug_tab == null) {
                buffer.append("'" + doiID + "' tracing level is 0");
                return;
            }
            Integer debugLevel = (Integer)debug_tab.get(doiID);
            buffer.append("'" + doiID + "' tracing level is " + debugLevel);
        }

        private void showAll(StringBuffer buffer) {
            String[] doiIDs = this.getDOInstances();
            if (doiIDs.length == 0) {
                if (GLOBAL_DEBUG_ON) {
                    buffer.append("GLOBAL_DEBUG_ON is set, debugDiagnosticLevel is set to " + debugDiagnosticLevel);
                } else {
                    buffer.append(NO_TRACING_MESSAGE);
                }
                return;
            }
            if (debugDiagnosticLevel != 0) {
                buffer.append("    debugDiagnosticLevel is set to " + debugDiagnosticLevel).append(NEWLINE);
            }
            for (int i = 0; i < doiIDs.length; ++i) {
                buffer.append("  '" + doiIDs[i] + "' tracing level is " + debug_tab.get(doiIDs[i])).append(NEWLINE);
            }
        }

        @Override
        public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
            String diagLevel = (String)parameters.get("integerTraceLevel");
            int classFlags = -1;
            if (diagLevel != null) {
                try {
                    classFlags = DebugMasks.adjustFlags(Integer.parseInt(diagLevel));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (classFlags != 0) {
                if (doiID != null) {
                    DEBUG_CLASS_ON = true;
                } else {
                    DEBUG_DIAG_ON = true;
                }
            }
            boolean bl = GLOBAL_DEBUG_ON = DEBUG_CLASS_ON || DEBUG_DIAG_ON;
            if (debug_tab == null) {
                debug_tab = new Hashtable();
            }
            if (doiID != null) {
                debug_tab.put(doiID, classFlags);
                buffer.append("'" + doiID + "' debugging level is set to " + classFlags);
            } else {
                debugDiagnosticLevel = classFlags;
                buffer.append("Global debugging level is set to " + classFlags);
            }
        }

        public void setDebugCallback(String doiID, HashMap parameters, StringBuffer buffer) {
            if (parameters.containsKey("help")) {
                this.printFromFileToBuffer(SET_DEBUG_CALLBACK_HELP, buffer);
            } else {
                Map.Entry entry = parameters.entrySet().iterator().next();
                DebugState.parseCallbacks(doiID + ":" + entry.getValue());
                buffer.append("'" + doiID + "' setting debug callback: " + entry.getValue());
            }
        }

        public void clearDebugCallback(String doiID, HashMap parameters, StringBuffer buffer) {
            if (parameters.containsKey("help")) {
                this.printFromFileToBuffer(CLEAR_DEBUG_CALLBACK_HELP, buffer);
            } else {
                Map.Entry entry = parameters.entrySet().iterator().next();
                debug_callbacks.remove(doiID);
                buffer.append("'" + doiID + "' clearing debug callback: " + entry.getValue());
            }
        }

        public void setMgramCallbackFilter(HashMap parameters, StringBuffer buffer) {
            if (parameters.containsKey("help")) {
                this.printFromFileToBuffer(SET_MGRAM_CALLBACK_FILTER_HELP, buffer);
            } else {
                Map.Entry entry = parameters.entrySet().iterator().next();
                MgramFilterSupport.changeFilters(entry.getKey().toString());
                buffer.append("Setting Mgram callback filter: " + entry.getKey().toString());
            }
        }

        public void clearMgramCallbackFilter(StringBuffer buffer) {
            MgramFilterSupport.changeFilters(NOMATCH_FILTER);
            buffer.append("Clearing Mgram callback filter");
        }

        public void setLogCallbackFilter(HashMap parameters, StringBuffer buffer) {
            if (parameters.containsKey("help")) {
                this.printFromFileToBuffer(SET_LOG_CALLBACK_FILTER_HELP, buffer);
            } else {
                Map.Entry entry = parameters.entrySet().iterator().next();
                LogFilterSupport.changeFilters((String)entry.getKey().toString());
                buffer.append("Setting log callback filter: " + entry.getKey().toString());
            }
        }

        public void clearLogCallbackFilter(StringBuffer buffer) {
            LogFilterSupport.changeFilters((String)NOMATCH_FILTER);
            buffer.append("Clearing log callback filter");
        }

        @Override
        public void executeOperation(String doiID, String operation, HashMap parameters, StringBuffer buffer) {
            if (operation.equals(SET_DEBUG_CALLBACK)) {
                this.setDebugCallback(doiID, parameters, buffer);
            } else if (operation.equals(CLEAR_DEBUG_CALLBACK)) {
                this.clearDebugCallback(doiID, parameters, buffer);
            } else if (operation.equals(SET_MGRAM_CALLBACK_FILTER)) {
                this.setMgramCallbackFilter(parameters, buffer);
            } else if (operation.equals(CLEAR_MGRAM_CALLBACK_FILTER)) {
                this.clearMgramCallbackFilter(buffer);
            } else if (operation.equals(SET_LOG_CALLBACK_FILTER)) {
                this.setLogCallbackFilter(parameters, buffer);
            } else if (operation.equals(CLEAR_LOG_CALLBACK_FILTER)) {
                this.clearLogCallbackFilter(buffer);
            } else {
                buffer.append(operation + " Not implemented");
            }
        }
    }
}

