/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.zclient.DebugThread;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.SessionConfig;

final class SessionMessageProcessor
extends DebugThread {
    private MessageHandler m_handler;
    private static int m_instanceCount;
    int m_id;

    public SessionMessageProcessor(MessageHandler mh, int id, String appid) {
        super("SessionMessageProcessor (" + ++m_instanceCount + ") " + id + ": " + (mh == null || mh.getName() == null ? "" : mh.getName() + ", ") + appid);
        this.m_handler = mh;
        this.m_id = id;
    }

    @Override
    public void threadMain() {
        if (this.DEBUG) {
            this.debug("starting");
        }
        if (SessionConfig.DEBUG) {
            System.out.println("handler = " + this.m_handler);
            System.out.println("message box = " + this.m_handler.getMessageQueue());
        }
        while (!Thread.interrupted() && !this.isShuttingDown()) {
            try {
                this.m_handler.doNextWorkItem(this.m_id);
                Thread.yield();
            }
            catch (InterruptedException e) {
                break;
            }
            if (!SessionConfig.IN_BROKER || !SessionConfig.BROKER_EXITING) continue;
            break;
        }
    }
}

