/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPNetworkLink;

public final class HTTPConstants {
    public static final boolean DEBUG = EvsHTTPNetworkLink.DEBUG_NEW_HTTP;
    public static final boolean DEBUG_UNEXPECTED = EvsHTTPNetworkLink.DEBUG_UNEXPECTED;
    public static final boolean DEBUG_PERFORMANCE = false;
    public static final boolean DEBUG_LIFECYCLE = false;
    static final int MAX_HTTP_HEADER_LINE_LENGTH = 8192;
    static final int MAX_HTTP_CHUNK_SIZE = 65536;
    public static final String HTTP_NTLM_AUTH_DOMAIN;
    static final String HTTP_NON_PROXY_HOSTS_PROP = "http.nonProxyHosts";
    static final String HTTP_NON_PROXY_HOSTS;
    public static final String HTTP_NTLM_AUTH_WORKSTATION;
    static final String HTTP_MAX_PIPELINE_REQUESTS_PROP = "sonic.httpclient.maxPipelineRequests";
    public static final int HTTP_MAX_PIPELINE_REQUESTS;
    static final String HTTP_CHUNKING_THRESHOLD_PROP = "sonic.httpclient.chunkingThreshold";
    public static final int HTTP_CHUNKING_THRESHOLD;
    static final String MAX_HTTP_HEADER_BUFFER_SIZE_PROP = "sonic.http.maxHeaderBufferSize";
    public static final int MAX_HTTP_HEADER_BUFFER_SIZE;
    public static final boolean HTTP_RUNNING_FROM_BROWSER;

    private static int parseData(String propertyName, int maxParam) {
        int max = maxParam;
        String str = System.getProperty(propertyName);
        if (str != null) {
            max = Integer.parseInt(str.trim());
        }
        return max;
    }

    static {
        String authDom = "";
        try {
            authDom = System.getProperty("http.auth.ntlm.domain");
        }
        catch (SecurityException se) {
            System.out.println("Invalid property permissions denied for: http.auth.ntlm.domain");
        }
        HTTP_NTLM_AUTH_DOMAIN = authDom;
        int max = Integer.MAX_VALUE;
        try {
            max = HTTPConstants.parseData(HTTP_MAX_PIPELINE_REQUESTS_PROP, max);
        }
        catch (NumberFormatException nfe) {
            System.err.println("sonic.httpclient.maxPipelineRequests: " + nfe.getMessage());
            nfe.printStackTrace();
        }
        catch (SecurityException se) {
            System.out.println("Invalid property permissions denied for: sonic.httpclient.maxPipelineRequests");
        }
        HTTP_MAX_PIPELINE_REQUESTS = max;
        max = 8192;
        try {
            max = HTTPConstants.parseData(MAX_HTTP_HEADER_BUFFER_SIZE_PROP, max);
        }
        catch (NumberFormatException nfe) {
            System.err.println("sonic.http.maxHeaderBufferSize: " + nfe.getMessage());
            nfe.printStackTrace();
        }
        catch (SecurityException se) {
            System.out.println("Invalid property permissions denied for: sonic.http.maxHeaderBufferSize");
        }
        MAX_HTTP_HEADER_BUFFER_SIZE = max;
        int threshold = 0;
        try {
            String str = System.getProperty(HTTP_CHUNKING_THRESHOLD_PROP);
            if (str != null) {
                threshold = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("sonic.httpclient.chunkingThreshold: " + nfe.getMessage());
            nfe.printStackTrace();
        }
        catch (SecurityException se) {
            System.out.println("Invalid property permissions denied for: sonic.httpclient.chunkingThreshold");
        }
        HTTP_CHUNKING_THRESHOLD = threshold;
        String nonProxyHosts = null;
        try {
            nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS_PROP);
        }
        catch (SecurityException se) {
            System.out.println("Invalid property permissions denied for: http.nonProxyHosts");
        }
        HTTP_NON_PROXY_HOSTS = nonProxyHosts;
        String workstation = System.getProperty("sonic.http.auth.ntlmWorkStation");
        if (workstation == null) {
            try {
                workstation = EvsNetworkLink.LINK_INTERCEPTOR.getLocalHostName();
            }
            catch (EEvsIOException e) {
                System.out.println("Unable to determine name of local host for use as HTTP NTLM authentication workstation name: " + e.toString());
            }
        }
        HTTP_NTLM_AUTH_WORKSTATION = workstation;
        SecurityManager manager = System.getSecurityManager();
        HTTP_RUNNING_FROM_BROWSER = manager != null && manager.getClass().getName().startsWith("sun.plugin");
    }
}

