/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Vector;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.PriorityQueue;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IExpireCheck;
import progress.message.zclient.IFlowControllableOutputQueue;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.OutQueue;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.xonce.IOutboundContext;

public abstract class SenderQueue
extends DebugObject
implements IExpireCheck,
IFlowControllableOutputQueue {
    protected OutQueue m_outQueue;
    protected PrioQueueLimiter m_outLimiter;
    protected IndexedList m_pendingQmsgs;
    protected PrioQueueLimiter m_pendingQmsgsLimiter;
    protected String m_localNodeName = null;
    protected IOutboundContext m_outboundContext = null;

    public SenderQueue(IOutboundContext oc, OutQueue oq, PrioQueueLimiter outLimiter, IndexedList pendingQmsgs, PrioQueueLimiter pendingQmsgsLimiter, String localNodeName) {
        super(DebugState.GLOBAL_DEBUG_ON ? "SenderQueue" : null);
        this.m_outQueue = oq;
        this.m_outLimiter = outLimiter;
        this.m_pendingQmsgs = pendingQmsgs;
        this.m_pendingQmsgsLimiter = pendingQmsgsLimiter;
        this.m_outboundContext = oc;
        this.m_localNodeName = localNodeName;
    }

    public abstract void enqueue(IMgram var1, int var2) throws Exception;

    public abstract Object dequeueAtOrAbove(int var1);

    public abstract Object dequeue(int var1);

    public synchronized boolean checkForOutgoingMsgs() {
        IPTPFlowControlHandler fc = this.m_outboundContext.getPTPFlowControlHandler();
        return !this.m_outQueue.isEmpty() || fc != null && fc.hasBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpOutQueue() {
        IPTPFlowControlHandler fc = this.m_outboundContext.getPTPFlowControlHandler();
        if (fc != null) {
            fc.dropBlocked();
        }
        OutQueue outQueue = this.m_outQueue;
        synchronized (outQueue) {
            while (!this.m_outQueue.isEmpty()) {
                this.m_outQueue.dequeue();
            }
        }
        this.m_outLimiter.reset();
    }

    public synchronized void restorePendingQmsgs(IndexedList pendingQmsgs, PrioQueueLimiter pendingQmsgsLimiter) {
        this.m_pendingQmsgs = pendingQmsgs;
        this.m_pendingQmsgsLimiter = pendingQmsgsLimiter;
    }

    public abstract Vector getExpiredMsgs();

    @Override
    public abstract boolean isMsgExpired(Object var1);

    @Override
    public abstract PriorityQueue getOutputQueue();

    @Override
    public abstract PrioQueueLimiter getOutputQueueLimiter();

    @Override
    public abstract IndexedList getQueueMsgPendingQueue();
}

