/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.zclient.ClientSecurityContext;

public final class ConnectData {
    private ClientSecurityContext m_csc;
    private String m_brokerName;
    private String m_collectiveName;
    private long m_socketId;

    protected ConnectData() {
    }

    public ConnectData(ClientSecurityContext csc, String brokerName, String collectiveName, long socketId) {
        this.m_csc = csc;
        this.m_brokerName = brokerName;
        this.m_collectiveName = collectiveName;
        this.m_socketId = socketId;
    }

    public ClientSecurityContext getSecurityContext() {
        return this.m_csc;
    }

    public String getBrokerName() {
        return this.m_brokerName;
    }

    public String getCollectiveName() {
        return this.m_collectiveName;
    }

    public long getSocketId() {
        return this.m_socketId;
    }

    public void writeToStream(DataOutput stream, short version) throws IOException {
        stream.writeUTF(this.m_brokerName);
        stream.writeUTF(this.m_collectiveName);
        stream.writeLong(this.m_socketId);
        this.m_csc.writeToStream(stream, version);
    }

    public void readFromStream(DataInput stream, short version) throws IOException {
        this.m_brokerName = stream.readUTF();
        this.m_collectiveName = stream.readUTF();
        this.m_socketId = stream.readLong();
        this.m_csc = ClientSecurityContext.getClientSecurityContext(stream, version);
    }

    public static ConnectData getConnectData(DataInput stream, short version) throws IOException {
        ConnectData cd = new ConnectData();
        cd.readFromStream(stream, version);
        return cd;
    }
}

