/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import progress.message.client.EAlreadyConnected;
import progress.message.client.EAnonymousConnectionDisallowed;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.ECredentialInUse;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EGeneralException;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidSelectorException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.EParameterIsNull;
import progress.message.client.EPasswordExpired;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnknownBrokerHost;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.prAccessor;
import progress.message.jclient.DestinationFactory;
import progress.message.jimpl.Connection;
import progress.message.jimpl.Destination;
import progress.message.jimpl.ISelectorFactory;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.MultiTopic;
import progress.message.jimpl.Session;
import progress.message.jimpl.SessionAcknowledgeQueue;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subscription;

public class DurableSubscriber
extends MessageConsumer
implements TopicSubscriber {
    public static final int AppIdMaxLength = 1024;
    private static final String MESSAGE_SELECTOR_FACTORY_CLASS = "progress.message.jimpl.parser.SelectorFactory";
    String m_clientId = null;
    String m_name = null;
    Topic m_appTopic = null;
    Destination m_dest = null;
    private boolean m_isSelectorAtBroker = false;
    boolean m_inhibitLocalDelivery = false;
    private IMessageHandler m_ihandler;
    private Subscription m_subscription = null;
    private boolean m_waitingForDeliveryStop = false;
    private boolean m_enforceCWADSStrictMessagOrder = false;
    private int m_flowToDisk = 0;

    public DurableSubscriber(Connection jconnection, Session jsession, String name, Topic topic) throws JMSException {
        this(jconnection, jsession, name, topic, null, false, null, -1L);
    }

    public DurableSubscriber(Connection jconnection, Session jsession, String name, Topic topic, long timeToLive) throws JMSException {
        this(jconnection, jsession, name, topic, null, false, null, timeToLive);
    }

    public DurableSubscriber(Connection jconnection, Session jsession, String name, Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this(jconnection, jsession, name, topic, messageSelector, noLocal, null, -1L);
    }

    public DurableSubscriber(Connection jconnection, Session jsession, String name, Topic topic, String messageSelector, boolean noLocal, long timeToLive) throws JMSException {
        this(jconnection, jsession, name, topic, messageSelector, noLocal, null, timeToLive);
    }

    public DurableSubscriber(Connection jconnection, Session jsession, String name, Topic topic, String messageSelector, boolean noLocal, IMessageHandler ihr) throws JMSException {
        this(jconnection, jsession, name, topic, messageSelector, noLocal, ihr, -1L);
    }

    public DurableSubscriber(Connection jconnection, Session jsession, String name, Topic topic, String messageSelector, boolean noLocal, IMessageHandler ihr, long timeToLive) throws JMSException {
        super(jsession);
        this.m_jconnection = jconnection;
        this.setupTopic(topic);
        ISubject subject = this.m_dest.getSubject().clearSubjectTracking();
        if (subject.hasTemporary()) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("DURABLESUBSCRIPTION_INVALID_TEMP_TOPIC"), null);
        }
        try {
            this.m_name = name;
            if (!subject.hasGroup()) {
                this.m_inhibitLocalDelivery = noLocal;
            }
            this.m_selectorString = messageSelector;
            this.m_isSelectorAtBroker = this.m_jconnection.isSelectorAtBroker();
            if (!this.m_isSelectorAtBroker && this.m_selectorString != null && this.m_selectorString.length() > 0) {
                ISelectorFactory factory = null;
                try {
                    Class<?> c = Class.forName(MESSAGE_SELECTOR_FACTORY_CLASS);
                    factory = (ISelectorFactory)c.newInstance();
                }
                catch (Exception e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + MESSAGE_SELECTOR_FACTORY_CLASS, e);
                }
                if (factory != null) {
                    this.m_selector = factory.createMessageSelector(this.m_selectorString);
                }
            }
            this.m_enforceCWADSStrictMessagOrder = jsession.getDurableMessageOrder();
            this.m_flowToDisk = jsession.getFlowToDisk();
            this.m_clientId = this.m_jconnection.getClientID();
            String appId = null;
            long parentID = 0L;
            if (jsession == jconnection.getDefaultJSession()) {
                this.m_isCC = true;
                parentID = this.m_jconnection.m_zconnection.getClientId();
                appId = SessionConfig.createDurableAppid(this.m_clientId, name, true);
            } else {
                parentID = jsession.m_zconnection.getClientId();
                appId = SessionConfig.createDurableAppid(this.m_clientId, name, false);
            }
            if (appId.length() > 1024) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("APPID_TOO_LONG"), null);
            }
            this.m_zmessageHandler = new DefaultHandler(!this.m_isCC);
            this.m_zmessageHandler.setGuaranteed(true);
            this.m_zconnection = this.m_jconnection.getMinimizeSubscriberTraffic() ? new progress.message.zclient.Connection(appId, null, this.m_zmessageHandler, true) : new progress.message.zclient.Connection(appId, null, this.m_zmessageHandler);
            this.m_zconnection.setAckMode(this.m_jsession.getZAckMode());
            this.m_jconnection.addZConnection(this.m_zconnection);
            this.m_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            this.m_ihandler = ihr != null ? ihr : new IHandler();
            Label label = new Label();
            label.setPersistent(true);
            if (timeToLive > 0L) {
                label.setExpirationTime(timeToLive);
            }
            this.m_subscription = this.m_zmessageHandler.getSession().submitJMSSubscription(subject, label, this.m_selectorString, this.m_isSelectorAtBroker, this.m_enforceCWADSStrictMessagOrder, this.m_flowToDisk, true);
            this.m_zmessageHandler.bind(subject, this.m_ihandler);
            if (!this.m_isCC) {
                Session sess = jsession;
                sess.addDurableSubscriber(name, this);
                if ((noLocal || !this.m_isSelectorAtBroker && this.m_selector != null) && sess.getAcknowledgeQueue() == null) {
                    sess.startSAP();
                }
            } else {
                this.m_jconnection.addDurableCC(name, this);
            }
        }
        catch (EDefaultHandlerNotSet e) {
            this.handleException(e);
        }
        catch (EInvalidSubjectSyntax e) {
            this.handleException(e);
        }
        catch (ENetworkFailure e) {
            this.handleException(e);
        }
        catch (EBrokerVersionMismatch e) {
            this.handleException(e);
        }
        catch (EParameterIsNull e) {
            this.handleException(e);
        }
        catch (EConnectionLimitExceeded e) {
            this.handleException(e, -26, e.getMessage());
        }
        catch (ECredentialInUse e) {
            this.handleException(e);
        }
        catch (EUnknownBrokerHost e) {
            this.handleException(e);
        }
        catch (EAlreadyConnected e) {
            this.handleException(e);
        }
        catch (EInauthenticBroker e) {
            this.handleException(e);
        }
        catch (EUserAlreadyConnected e) {
            this.handleException(e);
        }
        catch (EAnonymousConnectionDisallowed e) {
            this.handleException(e);
        }
        catch (EInvalidApplicationId e) {
            this.handleException(e);
        }
        catch (EPasswordExpired e) {
            this.handleException(e);
        }
        catch (EUnusableConnection e) {
            this.handleException(e);
        }
        catch (ESecurityPolicyViolation e) {
            this.handleException(e);
        }
        catch (ESecurityGeneralException e) {
            this.handleException(e);
        }
        catch (InvalidSelectorException ise) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw ise;
        }
        catch (EInvalidSelectorException e) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw new InvalidSelectorException(e.getMessage() + " (Topic: " + this.m_appTopic + ", Durable Name: " + this.m_name + ", Selector: " + (this.m_selectorString == null ? "null" : "\"" + this.m_selectorString + "\"") + ")");
        }
        catch (EGeneralException e) {
            this.handleException(e);
        }
        catch (JMSException e) {
            this.handleException(e);
        }
    }

    private final void setupTopic(Topic topic) throws JMSException {
        ISubject subject;
        if (topic == null) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_UNIDENT_TOPIC"));
        }
        this.m_appTopic = topic;
        this.m_dest = (Destination)DestinationFactory.createSonicDestination(this.m_appTopic);
        if (this.m_dest.hasRouting()) {
            String routingNodeName = this.m_dest.getRouting();
            String localRoutingNodeName = this.m_jconnection.getRoutingNodeName();
            if (routingNodeName != null && !routingNodeName.equals(localRoutingNodeName) && !"".equals(routingNodeName)) {
                throw new InvalidDestinationException(prAccessor.getString("TOPICSUBSCRIBER_CANNOT_USE_REMOTE_TOPIC"));
            }
        }
        if (!(subject = this.m_dest.getSubject()).isSubjectSet()) {
            throw JMSExceptionUtil.createJMSException(new EInvalidSubjectSyntax(prAccessor.getString("STR128")));
        }
        if (subject.isMultiSubject()) {
            this.m_dest = ((MultiTopic)this.m_dest).protectedClone();
            this.m_appTopic = (MultiTopic)this.m_dest;
        }
    }

    private void handleException(Exception e) throws JMSException {
        this.removeConnection(e);
        throw JMSExceptionUtil.createJMSException(e);
    }

    private void handleException(Exception e, int errorCode, String reason) throws JMSException {
        this.removeConnection(e);
        throw JMSExceptionUtil.createJMSException(reason, "" + errorCode, e);
    }

    private void removeConnection(Exception e) throws JMSException {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
        if (e instanceof JMSException) {
            throw (JMSException)e;
        }
    }

    @Override
    public Topic getTopic() throws JMSException {
        return this.m_appTopic;
    }

    @Override
    public boolean getNoLocal() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_inhibitLocalDelivery;
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeInternalConsumer() throws JMSException {
        Object ex2;
        block27: {
            if (this.m_started) {
                this.stop();
            }
            if (!this.m_isCC) {
                if (!this.m_jsession.okToCloseConsumer(this)) {
                    this.m_pendingClose = true;
                    return;
                }
            } else if (!this.m_jconnection.isClosing()) {
                Enumeration<Session> sessions = this.m_jconnection.getSessions();
                while (sessions.hasMoreElements()) {
                    Session sess = sessions.nextElement();
                    if (sess.okToCloseConsumer(this)) continue;
                    this.m_pendingClose = true;
                    return;
                }
            }
            this.m_pendingClose = false;
            try {
                this.m_jsession.setDelayedAcknowledgeMessage(null);
            }
            catch (JMSException e) {
                ex2 = e.getLinkedException();
                if (ex2 != null && ex2 instanceof ENotConnected) break block27;
                throw e;
            }
        }
        this.m_jconnection.removeZConnection(this.m_zconnection);
        boolean needToRestartDeliveryThread = false;
        if (!this.m_isCC && this.m_jsession.isDeliveryThreadStarted() && this.m_jsession.m_thread != Thread.currentThread()) {
            needToRestartDeliveryThread = true;
            this.m_waitingForDeliveryStop = true;
            try {
                this.m_jsession.stopDeliveryThread();
            }
            finally {
                this.m_waitingForDeliveryStop = false;
            }
        }
        this.m_zmessageHandler.unbind(this.m_dest.getSubject());
        try {
            if (!this.m_isCC) {
                ex2 = this.getReceivedMessagesQueue();
                synchronized (ex2) {
                    this.getReceivedMessagesQueue().removeAllMessages();
                    this.getReceivedMessagesQueue().notifyAll();
                }
                this.m_jsession.removeDurableSubscriber(this.m_name);
            } else {
                this.m_jconnection.removeDurableCC(this.m_name);
            }
            try {
                this.m_zconnection.disconnect(false);
            }
            catch (ENotConnected ex2) {
                // empty catch block
            }
            if (!this.m_isCC && needToRestartDeliveryThread && !this.m_jsession.isClosing()) {
                this.m_jsession.startDeliveryThread();
            }
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENotConnected e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EDefaultHandlerNotSet e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    public void close() throws JMSException {
        this.m_jsession.beginWaitForSession();
        try {
            this.closeImpl();
        }
        finally {
            this.m_jsession.endWaitForSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() throws JMSException {
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.isClosing() && !this.isClosePending() && this.m_waitingForDeliveryStop) {
                this.m_jsession.stopDeliveryThread();
                return;
            }
            if (this.isClosing() && !this.isClosePending()) {
                return;
            }
            try {
                if (this.m_jsession.m_transacted && this.m_jsession.getAckListEnabled()) {
                    this.sendBatch(false, true);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.m_closing = true;
            this.closeInternalConsumer();
        }
    }

    @Override
    void acknowledge(Envelope env) throws JMSException {
        if (this.m_jsession.getTransactedFlag()) {
            if (this.m_jsession.getAckListEnabled()) {
                this.batchAck(env);
            } else {
                this.acknowledge(env, this.m_zconnection.getClientId());
            }
        } else {
            progress.message.zclient.Session zs = this.m_zmessageHandler.getSession();
            if (zs == null) {
                throw JMSExceptionUtil.createJMSException(new ENotConnected());
            }
            this.acknowledge(env, zs);
        }
    }

    @Override
    void batchAck(Envelope env) throws JMSException {
        try {
            long clientId = this.m_zconnection.getClientId();
            if (this.m_jsession.getTransactedFlag()) {
                this.m_jsession.getAckSession().batchAck(env, clientId);
            } else {
                this.m_zmessageHandler.getSession().batchAck(env, clientId);
            }
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    void processUndeliverable(Envelope env, int errorCode) throws JMSException {
    }

    @Override
    public Message checkUndeliverable(Message msg) throws JMSException {
        return msg;
    }

    void unsubscribe() throws JMSException, ENetworkFailure, ENotConnected, ESecurityPolicyViolation, EGeneralException {
        this.m_subscription.cancel();
    }

    @Override
    public int getPrefetchCount() {
        return -1;
    }

    @Override
    public int getPrefetchThreshold() {
        return -1;
    }

    @Override
    public void setPrefetchCount(int count) throws JMSException {
        throw new IllegalStateException("Prefetch Settings are PTP domain specific settings");
    }

    @Override
    public void setPrefetchThreshold(int threshold) throws JMSException {
        throw new IllegalStateException("Prefetch Settings are PTP domain specific settings");
    }

    @Override
    public void release(Message msg) {
        msg.getEnvelope().handlerDone(this.m_zmessageHandler.isGuaranteed(), true);
    }

    @Override
    public void release(Envelope env) {
        env.handlerDone(this.m_zmessageHandler.isGuaranteed(), true);
    }

    private class DefaultHandler
    extends MessageHandler {
        DefaultHandler(boolean noThread) {
            super(null, true, noThread);
            this.setName("DurableSubscriber msg handler");
        }

        @Override
        public void handleMessage(progress.message.zclient.Session s, Envelope env) {
            if (DurableSubscriber.this.isClosing()) {
                env.handlerDone(DurableSubscriber.this.m_zmessageHandler.isGuaranteed(), true);
            } else {
                env.handlerDone(DurableSubscriber.this.m_zmessageHandler.isGuaranteed(), false);
            }
        }
    }

    private class IHandler
    implements IMessageHandler {
        private IHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope env) {
            Message msg = null;
            if (DurableSubscriber.this.m_inhibitLocalDelivery && env.getBrokerID() == DurableSubscriber.this.m_jconnection.getBrokerID()) {
                long connID = DurableSubscriber.this.m_jconnection.getConnectionID();
                long msgID = env.getConnectionAndLocalID();
                if (msgID >> 16 == connID) {
                    try {
                        SessionAcknowledgeQueue msgQueue;
                        msg = DurableSubscriber.this.extract(env);
                        msg.setConsumer(DurableSubscriber.this);
                        SessionAcknowledgeQueue sessionAcknowledgeQueue = msgQueue = DurableSubscriber.this.m_jsession.getAcknowledgeQueue();
                        synchronized (sessionAcknowledgeQueue) {
                            msgQueue.addMessage(msg);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
            }
            try {
                msg = DurableSubscriber.this.extract(env);
                if (DurableSubscriber.this.m_selector != null && !DurableSubscriber.this.m_selector.match(msg)) {
                    try {
                        SessionAcknowledgeQueue msgQueue;
                        msg.setConsumer(DurableSubscriber.this);
                        SessionAcknowledgeQueue sessionAcknowledgeQueue = msgQueue = DurableSubscriber.this.m_jsession.getAcknowledgeQueue();
                        synchronized (sessionAcknowledgeQueue) {
                            msgQueue.addMessage(msg);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                DurableSubscriber.this.enqueueReceivedMessage(env, msg);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

