/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.capture;

import java.io.IOException;
import java.io.InputStream;
import progress.message.util.IDumpable;
import progress.message.util.InputStreamWrapper;
import progress.message.util.capture.CaptureBuffer;

public class CaptureInputStream
extends InputStreamWrapper
implements IDumpable {
    private final CaptureBuffer m_cb;

    public CaptureInputStream(InputStream is, int size) {
        super(is);
        this.m_cb = new CaptureBuffer(size);
    }

    @Override
    public final int read() throws IOException {
        int r = this.m_is.read();
        if (r == -1) {
            return -1;
        }
        this.m_cb.capture((byte)r);
        return r;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int r = this.m_is.read(b, off, len);
        if (r > 0) {
            this.m_cb.capture(b, off, r);
        }
        return r;
    }

    @Override
    public final int available() throws IOException {
        return this.m_is.available();
    }

    @Override
    public final void close() throws IOException {
        this.m_is.close();
    }

    @Override
    public final void mark(int rl) {
        this.m_is.mark(rl);
    }

    @Override
    public final boolean markSupported() {
        return this.m_is.markSupported();
    }

    @Override
    public final void reset() throws IOException {
        this.m_is.reset();
    }

    @Override
    public final long skip(long n) throws IOException {
        return this.m_is.skip(n);
    }

    public final CaptureBuffer getCaptureBuffer() {
        return this.m_cb;
    }

    @Override
    public void dump(StringBuffer buf) {
        buf.append("Dump of CaptureInputStream\n");
        this.m_cb.dump(buf);
        if (this.m_is instanceof IDumpable) {
            ((IDumpable)((Object)this.m_is)).dump(buf);
        } else {
            buf.append("CaptureInputStream delegate is not dumpable: " + this.m_is);
        }
    }
}

