/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Iterator;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.SubjectCache;
import progress.message.util.WrappedDataInputStream;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EUnknownQop;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.IQop;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.QOP;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.prAccessor;

public class ClientQopCache
extends DebugObject
implements IMessageHandler {
    public static final int ITEM_NOT_FOUND = -1;
    private static final int CACHE_INITIAL_CAPACITY = 128;
    private SubjectCache m_table;
    private static int _id_cntr = 0;
    private int _id = 0;

    public ClientQopCache() {
        this(128);
    }

    public ClientQopCache(int maxSize) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ClientQopCache" : null);
        int initial = maxSize < 128 ? maxSize : 128;
        this.m_table = new SubjectCache(initial, maxSize);
        if (this.DEBUG) {
            this._id = ClientQopCache._getNextId();
        }
    }

    public synchronized void insert(int qop, ISubject subject) {
        QOP q = new QOP(qop);
        this.m_table.put(subject, q);
    }

    public synchronized IQop find(ISubject subject) {
        if (subject.isMultiSubject()) {
            Iterator<ISubject> i = subject.getMultiSubjects();
            QOP retQop = new QOP(0);
            while (i.hasNext()) {
                ISubject s = i.next();
                IQop qop = (IQop)this.m_table.get(s);
                if (qop == null) {
                    return null;
                }
                if (qop.getProtection() > retQop.getProtection()) {
                    try {
                        retQop.setProtection(qop.getProtection());
                    }
                    catch (EUnknownQop ex) {
                        SessionConfig.logMessage("Invalid QOP: " + qop, ex, SessionConfig.SEVERE);
                    }
                }
                if (retQop.getProtection() != 2) continue;
                return retQop;
            }
            return retQop;
        }
        return (IQop)this.m_table.get(subject);
    }

    public void handleUpdate(IMgram m) {
        ObjectInput input = m.getPayloadInputStreamHandle();
        WrappedDataInputStream is = new WrappedDataInputStream(input);
        try {
            int count = input.readShort();
            for (int i = 0; i < count; ++i) {
                byte qop = input.readByte();
                ISubject s = Subject.createFromStream(is);
                this.updateQop(s, qop);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleMessage(Session context, Envelope envelope) {
        String subjectStr;
        Message message = (Message)envelope.getMessage().clone();
        int[] mv = null;
        short sentValue = 0;
        try {
            sentValue = message.readByte();
            int len = message.readShort();
            mv = new int[len];
            for (int cur = 0; cur < len; ++cur) {
                mv[cur] = message.readInt();
            }
            subjectStr = message.readUTF();
        }
        catch (IOException ioe) {
            throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR003"), new Object[]{message.getSubject()}));
        }
        Subject subject = new Subject(subjectStr, mv);
        this.updateQop(subject, (byte)sentValue);
    }

    private final void updateQop(ISubject subject, byte sentValue) {
        IQop currentQop = this.find(subject);
        short currentValue = 0;
        if (currentQop == null) {
            if (this.DEBUG) {
                this.debug(this._id + ": adding subject: " + subject + " qop: ");
                SecurityLogic.debugPrintPublic(sentValue);
            }
            this.insert(sentValue, subject);
        } else {
            currentValue = currentQop.getProtection();
            if (currentValue != sentValue) {
                if (this.DEBUG) {
                    this.debug(this._id + ": replacing subject: " + subject + " qop: ");
                    SecurityLogic.debugPrintPublic((byte)currentValue);
                }
                try {
                    currentQop.setProtection(sentValue);
                }
                catch (EUnknownQop e) {
                    throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR004"), new Object[]{Short.toString(sentValue)}), e);
                }
            }
        }
    }

    private static int _getNextId() {
        return ++_id_cntr;
    }
}

