/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.ws.rm.api.ISequenceStatusReporter;
import com.sonicsw.ws.rm.api.ISequenceTerminator;
import org.apache.axis.client.Stub;

public class RMSequence {
    private String m_identifier;
    private int m_messageNumber;
    private ISequenceTerminator m_terminator;
    private ISequenceStatusReporter m_reporter;
    private String m_JMSPolicyProperty;
    private boolean m_preparedLast;

    public RMSequence(String id, String policy, ISequenceTerminator terminator, ISequenceStatusReporter reporter) {
        this.m_messageNumber = 1;
        this.m_identifier = id;
        this.m_JMSPolicyProperty = policy;
        this.m_terminator = terminator;
        this.m_reporter = reporter;
    }

    public void attach(Stub s) throws Exception {
        s._setProperty("QA_SONICMQ_HTTP_WS_COMMON_RM_SEQUENCE", (Object)this);
    }

    public void detach(Stub s) throws Exception {
        s.removeProperty("QA_SONICMQ_HTTP_WS_COMMON_RM_SEQUENCE");
    }

    public void close() throws Exception {
        this.m_terminator.sendLast(this.m_identifier, this.m_messageNumber);
    }

    public void cancel() throws Exception {
        this.m_terminator.terminate(this.m_identifier);
    }

    public boolean isActive() throws Exception {
        return this.m_reporter.isActive(this.m_identifier);
    }

    public long getOutstandingMessageCount() throws Exception {
        return this.m_reporter.getOutstandingMessageCount(this.m_identifier);
    }

    public RMSequence() {
    }

    public boolean getPreparedLast() {
        return this.m_preparedLast;
    }

    public void prepareLast() {
        this.m_preparedLast = true;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public int getNextMessageNumber() {
        return this.m_messageNumber++;
    }

    public String getJMSPolicyProperty() {
        return this.m_JMSPolicyProperty;
    }
}

