/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.HashSet;
import java.util.LinkedList;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ICDispatchList;
import progress.message.zclient.IDispatchable;

class CDispatchListImpl
extends DebugObject
implements ICDispatchList {
    private LinkedList m_dispatchablesList;
    private HashSet m_dispatchables;
    private long m_numAdded;
    private long m_numNotAdded;
    private long m_continue;
    private long m_move;
    private long m_ct;

    public CDispatchListImpl(String ident) {
        super(DebugState.GLOBAL_DEBUG_ON ? "CDispatchListImpl " + ident : null);
        if (this.DEBUG && ident == null) {
            this.debugName("CDispatchListImpl " + this.hashCodeHelper());
        }
        this.m_dispatchablesList = new LinkedList();
        this.m_dispatchables = new HashSet(16);
        if (this.DEBUG) {
            this.debug("Constructed");
        }
    }

    private int hashCodeHelper() {
        return this.hashCode();
    }

    public CDispatchListImpl() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addDispatchable(IDispatchable obj) {
        boolean added = false;
        if (obj == null) {
            return false;
        }
        CDispatchListImpl cDispatchListImpl = this;
        synchronized (cDispatchListImpl) {
            if (!this.m_dispatchables.contains(obj)) {
                added = true;
                this.m_dispatchables.add(obj);
                this.m_dispatchablesList.add(obj);
            }
            if (this.DEBUG) {
                this.addCounter(added);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        CDispatchListImpl cDispatchListImpl = this;
        synchronized (cDispatchListImpl) {
            return this.m_dispatchables.size();
        }
    }

    @Override
    public final synchronized void remove(IDispatchable obj) {
        if (this.m_dispatchables.remove(obj)) {
            this.m_dispatchablesList.remove(obj);
        }
    }

    @Override
    public final synchronized void removeAll() {
        this.m_dispatchablesList.clear();
        this.m_dispatchables.clear();
    }

    @Override
    public final synchronized IDispatchable startDispatch() {
        IDispatchable obj = this.getNextDispatchable();
        return obj;
    }

    private IDispatchable getNextDispatchable() {
        IDispatchable obj = null;
        if (!this.m_dispatchablesList.isEmpty()) {
            obj = (IDispatchable)this.m_dispatchablesList.removeFirst();
            this.m_dispatchables.remove(obj);
        }
        return obj;
    }

    @Override
    public final synchronized IDispatchable getNextDispatchable(IDispatchable last, boolean reenqueue) {
        if (last == null) {
            return this.getNextDispatchable();
        }
        IDispatchable next = this.getNextDispatchable();
        if (next == null) {
            if (reenqueue) {
                if (this.DEBUG) {
                    this.continueCounter();
                }
                return last;
            }
            return null;
        }
        if (next == last) {
            next = this.getNextDispatchable();
            if (next == null) {
                return last;
            }
            reenqueue = true;
        }
        if (reenqueue) {
            this.addDispatchable(last);
            if (this.DEBUG) {
                this.moveToEndCounter();
            }
        }
        return next;
    }

    final void setIdent(String ident) {
        this.debugName("CDispatchList " + ident);
    }

    private void addCounter(boolean added) {
        ++this.m_ct;
        if (added) {
            ++this.m_numAdded;
        } else {
            ++this.m_numNotAdded;
        }
        this.printCounts();
    }

    private void continueCounter() {
        this.m_continue = this.incrementAndPrint(this.m_continue);
    }

    private void moveToEndCounter() {
        this.m_move = this.incrementAndPrint(this.m_move);
    }

    private long incrementAndPrint(long m_move) {
        ++this.m_ct;
        this.printCounts();
        return ++m_move;
    }

    private void printCounts() {
        if (this.m_ct == 100000L) {
            this.debug("Num adds= " + this.m_ct + "; added= " + this.m_numAdded + "; notAdded= " + this.m_numNotAdded + " continue " + this.m_continue + " move= " + this.m_move);
            this.m_numAdded = 0L;
            this.m_numNotAdded = 0L;
            this.m_continue = 0L;
            this.m_move = 0L;
            this.m_ct = 0L;
        }
    }
}

