/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.util.Vector;
import progress.message.msg.IMgram;
import progress.message.util.PriorityQueue;
import progress.message.zclient.Envelope;
import progress.message.zclient.ExpirationPriorityQueue;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.SessionConfig;

public class OutQueue
extends ExpirationPriorityQueue {
    public OutQueue(int numPriorities) {
        super(numPriorities);
    }

    public boolean isMsgExpired(Object obj) {
        if (obj instanceof IMgram) {
            IMgram m = (IMgram)obj;
            if (m.getNoOutqueueExpire()) {
                return false;
            }
            if (this.m_precheck != null && this.m_precheck.precheck(m) != 0) {
                return true;
            }
            if (m.isTTE()) {
                long expTm = m.getTTE();
                long now = System.currentTimeMillis();
                if (expTm != 0L && expTm < now) {
                    return true;
                }
            }
        } else if (obj instanceof PayloadWrapper) {
            PayloadWrapper pw = (PayloadWrapper)obj;
            long expTm = pw.getExpirationTime();
            long now = System.currentTimeMillis();
            if (expTm != 0L && expTm < now) {
                return true;
            }
        } else if (obj instanceof Envelope) {
            Envelope env = (Envelope)obj;
            long expTm = env.getLabel().getExpirationTime();
            return expTm > 0L && expTm < System.currentTimeMillis();
        }
        return false;
    }

    protected boolean checkForExpiredMsg(PriorityQueue.PriorityQueueElement elem) {
        Object obj = elem.getPayload();
        return this.isMsgExpired(obj);
    }

    public synchronized Vector removeTargeted(long targetId, PrioQueueLimiter limiter) {
        Vector<IMgram> ret = new Vector<IMgram>();
        Object payload = null;
        long size = 0L;
        int nextPrio = 0;
        PriorityQueue.PriorityQueueToken startToken = this.m_queueEnd[nextPrio + 1];
        PriorityQueue.PriorityQueueElement nextElem = startToken.m_next;
        PriorityQueue.PriorityQueueElement currentElem = null;
        while (true) {
            IMgram removedMgram;
            if (nextElem instanceof PriorityQueue.PriorityQueueToken) {
                if (++nextPrio >= this.m_numPriorities) break;
                nextElem = this.m_queueEnd[nextPrio + 1].m_next;
                continue;
            }
            currentElem = nextElem;
            nextElem = currentElem.m_next;
            payload = currentElem.getPayload();
            if (payload == null || !(payload instanceof IMgram) || (removedMgram = (IMgram)payload).getType() != 25 || removedMgram.getOperationHandle().getOperationType() != 3) continue;
            long clientID = -1L;
            try {
                clientID = removedMgram.getPayloadInputStreamHandle().readLong();
            }
            catch (IOException ioe) {
                SessionConfig.logMessage(ioe, SessionConfig.getLevelWarning());
                continue;
            }
            if (clientID != targetId) continue;
            IMgram fwdMgram = (IMgram)removedMgram.getOperationHandle().getMgramList().getFirst();
            ret.add(fwdMgram);
            size += (long)fwdMgram.getLimiterSize();
            this.deleteElem(currentElem);
            limiter.add(-removedMgram.getLimiterSize(), removedMgram.getPriority());
        }
        return ret;
    }

    public synchronized long[] getCountSizeOutgoingMsgs(boolean excludeGuar, boolean includeBatchCount) {
        int count = 0;
        long size = 0L;
        Object payload = null;
        int nextPrio = 0;
        PriorityQueue.PriorityQueueToken startToken = this.m_queueEnd[nextPrio + 1];
        PriorityQueue.PriorityQueueElement nextElem = startToken.m_next;
        PriorityQueue.PriorityQueueElement currentElem = null;
        while (true) {
            if (nextElem instanceof PriorityQueue.PriorityQueueToken) {
                if (++nextPrio >= this.m_numPriorities) break;
                nextElem = this.m_queueEnd[nextPrio + 1].m_next;
                continue;
            }
            currentElem = nextElem;
            nextElem = currentElem.m_next;
            payload = currentElem.getPayload();
            if (payload == null || !(payload instanceof IMgram)) continue;
            IMgram m = (IMgram)payload;
            if (excludeGuar && m.isGuarenteed()) continue;
            count = m.getType() == 27 && includeBatchCount ? (count += m.getBatchHandle().getBatchSize()) : ++count;
            size += (long)m.getLimiterSize();
        }
        long[] result = new long[]{count, size};
        return result;
    }
}

