/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import com.sonicsw.util.debug.Debug;
import java.text.MessageFormat;
import java.util.Stack;
import progress.message.client.ESecurityGeneralException;
import progress.message.crypto.DES;
import progress.message.crypto.MD5;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.util.Hex;
import progress.message.zclient.CryptoInfo;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.IMessageProtection;

public final class MessageProtection
implements IMessageProtection {
    private static boolean DEBUG_ALL = false;
    private static boolean DEBUG_MAC = false;
    private static boolean DEBUG_MKEY_ENCRYPTION = false;
    private static boolean DEBUG_SKEY_ENCRYPTION = false;
    public static final int HASH_LENGTH = 16;
    public static final int SECRET_KEY_LENGTH = 8;
    public static final int BLOCK_SIZE = 8;
    private static final byte[] s_pad_1;
    private static final byte[] s_pad_2;
    private final MessageDigest m_digest = new MD5();
    private final byte[] m_tempMacBuffer = new byte[16];
    private DES m_encrypt = null;
    private DES m_decrypt = null;
    private MultipleByteArrayEncrypter m_mbae = null;

    public final boolean isSonicCipherSuite() {
        return true;
    }

    public final void init(int operation, byte[] sessionKey) {
        if (operation == 1) {
            this.m_encrypt = new DES();
            this.m_encrypt.init(1, sessionKey);
        } else if (operation == 2) {
            this.m_decrypt = new DES();
            this.m_decrypt.init(2, sessionKey);
        } else {
            String mf99 = prAccessor.getString("STR034");
            Object[] ob99 = new Object[]{Integer.toString(operation)};
            throw new EAssertFailure(MessageFormat.format(mf99, ob99));
        }
    }

    public final int getSecretKeyLength() {
        return 8;
    }

    public final byte[] generateSessionKey(byte[] masterSecret, int bits) {
        byte[] sessionKey = new byte[8];
        switch (bits) {
            case 40: 
            case 56: {
                System.arraycopy(masterSecret, 0, sessionKey, 0, 8);
                if (bits == 56) break;
                for (int i = 0; i < 8; i += 2) {
                    int n = i;
                    sessionKey[n] = (byte)(sessionKey[n] & 0xE);
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new EAssertFailure(prAccessor.getString("STR036"));
            }
        }
        return sessionKey;
    }

    public final byte[] generateDigestKey(byte[] masterSecret) {
        byte[] digestKey = new byte[8];
        System.arraycopy(masterSecret, 8, digestKey, 0, 8);
        return digestKey;
    }

    public final int encrypt(byte[] key, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        DES des = new DES();
        des.init(1, key);
        return MessageProtection.debugMKeyEncryptionInputOutput(des, input, inputLen, inputOffset, output, outputOffset);
    }

    public final byte[] encrypt(byte[] key, CryptoInfoLinkedList encInfoLinkedList) throws ESecurityGeneralException {
        MessageProtection.debugMKeyEncryptionCryptoListSize(encInfoLinkedList);
        return this.multiByteArrayEncryptHelper(key, encInfoLinkedList, true);
    }

    private synchronized byte[] multiByteArrayEncryptHelper(byte[] key, CryptoInfoLinkedList encInfoLinkedList, boolean encrypt) {
        CryptoInfo info;
        if (this.m_mbae == null) {
            this.m_mbae = new MultipleByteArrayEncrypter();
        }
        this.m_mbae.init(key, encrypt);
        int lastPad = 0;
        while ((info = encInfoLinkedList.removeFirst()) != null) {
            this.m_mbae.update(info);
            lastPad = info.getPad();
        }
        if (lastPad == -1) {
            lastPad = 0;
        }
        return this.m_mbae.finish(lastPad);
    }

    public synchronized int encryptWithSessionKey(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.m_encrypt.doFinal(input, inputOffset, inputLen, output, outputOffset);
        return inputLen;
    }

    public int decrypt(byte[] key, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        DES des = new DES();
        des.init(2, key);
        return MessageProtection.debugMKeyEncryptionInputOutput(des, input, inputLen, inputOffset, output, outputOffset);
    }

    private static int debugMKeyEncryptionInputOutput(DES des, byte[] input, int inputLen, int inputOffset, byte[] output, int outputOffset) {
        des.doFinal(input, inputOffset, inputLen, output, outputOffset);
        return inputLen;
    }

    public final void decrypt(byte[] key, CryptoInfoLinkedList encInfoLinkedList) throws ESecurityGeneralException {
        MessageProtection.debugMKeyEncryptionCryptoListSize(encInfoLinkedList);
        this.multiByteArrayEncryptHelper(key, encInfoLinkedList, false);
    }

    private static void debugMKeyEncryptionCryptoListSize(CryptoInfoLinkedList encInfoLinkedList) {
    }

    public final synchronized int decryptWithSessionKey(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        this.m_decrypt.doFinal(input, inputOffset, inputLen, output, outputOffset);
        return inputLen;
    }

    public final int getOutputSize(int inputSize) {
        int padding = DES.computePad(inputSize);
        return inputSize + padding;
    }

    public synchronized int digest(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int outputLen) throws ESecurityGeneralException {
        this.m_digest.add(input, inputOffset, inputLen);
        this.m_digest.digest(output, outputOffset, outputLen);
        return 16;
    }

    public final synchronized int mac(byte[] keyBuffer, int keyOffset, int keyLength, byte[] messageBuffer, int messageOffset, int messageLength, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        this.m_digest.add(keyBuffer, keyOffset, keyLength);
        this.m_digest.add(s_pad_1, 0, s_pad_1.length);
        this.m_digest.add(messageBuffer, messageOffset, messageLength);
        this.configMDigestBufferDetails(keyBuffer, keyLength, keyOffset, macBuffer, macLength, macOffset);
        return 16;
    }

    public final synchronized int mac(byte[] keyBuffer, int keyOffset, int keyLength, CryptoInfoLinkedList macLinkedList, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        CryptoInfo info;
        this.m_digest.add(keyBuffer, keyOffset, keyLength);
        this.m_digest.add(s_pad_1, 0, s_pad_1.length);
        while ((info = macLinkedList.removeFirst()) != null) {
            this.m_digest.add(info.getBuffer(), info.getOffset(), info.getMessageLength());
        }
        this.configMDigestBufferDetails(keyBuffer, keyLength, keyOffset, macBuffer, macLength, macOffset);
        return 16;
    }

    private void debugTempMacBufferAndKey(byte[] keyBuffer, int keyLength, int keyOffset) {
        Debug.trace((String)(Thread.currentThread() + ": m_tempMacBuffer=" + Hex.toString((byte[])this.m_tempMacBuffer, (int)0, (int)16)));
        Debug.trace((String)(Thread.currentThread() + ": key=" + Hex.toString((byte[])keyBuffer, (int)keyOffset, (int)keyLength)));
    }

    private void configMDigestBufferDetails(byte[] keyBuffer, int keyLength, int keyOffset, byte[] macBuffer, int macLength, int macOffset) {
        this.m_digest.digest(this.m_tempMacBuffer, 0, 16);
        this.m_digest.add(keyBuffer, keyOffset, keyLength);
        this.m_digest.add(s_pad_2, 0, s_pad_2.length);
        this.m_digest.add(this.m_tempMacBuffer, 0, 16);
        this.m_digest.digest(macBuffer, macOffset, macLength);
    }

    public final synchronized boolean verifyMac(byte[] keyBuffer, int keyOffset, int keyLength, byte[] messageBuffer, int messageOffset, int messageLength, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        boolean retval = true;
        this.mac(keyBuffer, keyOffset, keyLength, messageBuffer, messageOffset, messageLength, this.m_tempMacBuffer, 0, 16);
        return this.debugMacBufferDetails(macBuffer, macLength, macOffset, retval);
    }

    public final synchronized boolean verifyMac(byte[] keyBuffer, int keyOffset, int keyLength, CryptoInfoLinkedList stack, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        this.mac(keyBuffer, keyOffset, keyLength, stack, this.m_tempMacBuffer, 0, 16);
        boolean retval = true;
        return this.debugMacBufferDetails(macBuffer, macLength, macOffset, retval);
    }

    private boolean debugMacBufferDetails(byte[] macBuffer, int macLength, int macOffset, boolean retvalParam) {
        boolean retval = retvalParam;
        for (int i = 0; i < 16; ++i) {
            if (macBuffer[macOffset + i] == this.m_tempMacBuffer[i]) continue;
            retval = false;
            break;
        }
        return retval;
    }

    public final int getHashSize() {
        return 16;
    }

    static {
        int padsize = 48;
        s_pad_1 = new byte[padsize];
        s_pad_2 = new byte[padsize];
        for (int i = 0; i < padsize; ++i) {
            MessageProtection.s_pad_1[i] = 54;
            MessageProtection.s_pad_2[i] = 92;
        }
    }

    final class MultipleByteArrayEncrypter {
        private int m_remainderBufferSize;
        private byte[] m_remainderBuffer;
        private byte[] m_clearBuffer;
        private byte[] m_padBuffer;
        private int m_remainderOffset;
        private DES m_des;
        private Stack m_lastBuffers;

        MultipleByteArrayEncrypter() {
            this.m_remainderBufferSize = MessageProtection.this.getOutputSize(1);
            this.m_remainderBuffer = new byte[this.m_remainderBufferSize];
            this.m_clearBuffer = new byte[this.m_remainderBufferSize];
            this.m_padBuffer = null;
            this.m_remainderOffset = 0;
            this.m_lastBuffers = new Stack();
        }

        public void init(byte[] key, boolean encrypt) {
            this.m_padBuffer = null;
            this.m_remainderOffset = 0;
            this.m_des = new DES();
            if (encrypt) {
                this.m_des.init(1, key);
            } else {
                this.m_des.init(2, key);
            }
        }

        public void update(CryptoInfo info) {
            int inputLen;
            int length;
            this.handleRemainder(info);
            byte[] buffer = info.getBuffer();
            int offset = info.getOffset();
            int remainder = length = info.getMessageLength();
            if (length >= this.m_remainderBufferSize) {
                remainder = length % this.m_remainderBufferSize;
                if (length >= this.m_remainderBufferSize) {
                    inputLen = length - remainder;
                    this.m_des.doFinal(buffer, offset, inputLen, buffer, offset);
                }
            }
            if (remainder > 0) {
                inputLen = length - remainder + offset;
                System.arraycopy(buffer, inputLen, this.m_remainderBuffer, 0, remainder);
                this.m_remainderOffset += remainder;
                info.setEncryptionLength(remainder);
                info.setEncryptEnd(true);
                this.m_lastBuffers.push(info);
            }
        }

        private void handleRemainder(CryptoInfo info) {
            if (this.m_remainderOffset > 0) {
                int bytesNeeded = this.m_remainderBufferSize - this.m_remainderOffset;
                int messageLength = info.getMessageLength();
                int bytesToCopy = messageLength < bytesNeeded ? messageLength : bytesNeeded;
                byte[] buffer = info.getBuffer();
                System.arraycopy(buffer, info.getOffset(), this.m_remainderBuffer, this.m_remainderOffset, bytesToCopy);
                info.setEncryptionLength(bytesToCopy);
                info.setEncryptEnd(false);
                this.m_lastBuffers.push(info);
                this.m_remainderOffset += bytesToCopy;
                info.setOffset(info.getOffset() + bytesToCopy);
                info.setMessageLength(info.getMessageLength() - bytesToCopy);
                this.checkFinish(0);
            }
        }

        private boolean checkFinish(int pad) {
            if (this.m_remainderOffset + pad == this.m_remainderBufferSize) {
                this.m_des.doFinal(this.m_remainderBuffer, 0, this.m_remainderBufferSize, this.m_remainderBuffer, 0);
                int remainderBufferCounter = this.m_remainderBufferSize;
                while (!this.m_lastBuffers.empty()) {
                    CryptoInfo lastInfo = (CryptoInfo)this.m_lastBuffers.pop();
                    byte[] lastInfoBuffer = lastInfo.getBuffer();
                    int lastInfoLength = lastInfo.getMessageLength();
                    int offset = lastInfo.getOffset();
                    boolean isEncryptedEnd = lastInfo.isEncryptEnd();
                    int encryptedLength = lastInfo.getEncryptionLength();
                    if (isEncryptedEnd) {
                        int lastInfoBufferLength = lastInfoLength;
                        int srcPos = remainderBufferCounter - encryptedLength - pad;
                        int destPos = offset + lastInfoBufferLength - encryptedLength;
                        System.arraycopy(this.m_remainderBuffer, srcPos, lastInfoBuffer, destPos, encryptedLength);
                    } else {
                        int srcPos = remainderBufferCounter - encryptedLength - pad;
                        System.arraycopy(this.m_remainderBuffer, srcPos, lastInfoBuffer, 0, encryptedLength);
                    }
                    remainderBufferCounter -= encryptedLength;
                }
                if (pad > 0) {
                    this.m_padBuffer = new byte[pad];
                    System.arraycopy(this.m_remainderBuffer, this.m_remainderBufferSize - pad, this.m_padBuffer, 0, pad);
                } else {
                    this.m_padBuffer = null;
                }
                this.m_remainderOffset = 0;
                System.arraycopy(this.m_clearBuffer, 0, this.m_remainderBuffer, 0, this.m_remainderBufferSize);
                return true;
            }
            return false;
        }

        public final byte[] finish(int pad) {
            this.checkFinish(pad);
            if (this.m_remainderOffset > 0) {
                throw new EAssertFailure("remBytes = " + (this.m_remainderBufferSize - this.m_remainderOffset));
            }
            return this.m_padBuffer;
        }
    }
}

