/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;

public class SecureInputStream
extends InputStream
implements ISecureInputStream {
    private static final int MAX_BUFFER_MULTIPLIER = 1024;
    private IMessageProtection m_mp = null;
    private byte[] m_key = null;
    private InputStream m_is = null;
    private byte[] m_buffer = null;
    private int m_location = -1;
    private int m_blockSize = 0;
    private int m_bufferSize = 0;
    private int m_bytesExpected = -1;

    public SecureInputStream() {
        this.m_mp = null;
        this.m_is = null;
        this.m_key = null;
        this.m_blockSize = 0;
        this.m_buffer = null;
    }

    public SecureInputStream(InputStream is, IMessageProtection mp, byte[] buffer) {
        this.initSecureInputStream(is, mp, buffer);
    }

    public final void initSecureInputStream(InputStream is, IMessageProtection mp, byte[] buffer) {
        this.m_mp = mp;
        this.m_is = is;
        this.m_key = null;
        this.m_blockSize = this.m_mp.getOutputSize(1);
        this.m_buffer = buffer == null ? new byte[this.m_blockSize * 1024] : buffer;
    }

    public final InputStream getInputStream() {
        return this;
    }

    public final void setMessageKey(byte[] key) {
        this.m_key = key;
    }

    public final void useSessionKey() {
        this.m_key = null;
    }

    @Override
    public final synchronized int read() throws IOException {
        if (this.m_location >= this.m_bufferSize || this.m_location == -1) {
            this.readBlock();
        }
        return this.m_buffer[this.m_location++] & 0xFF;
    }

    @Override
    public final synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        while (count < len) {
            if (this.m_location + (len - count) < this.m_bufferSize) {
                System.arraycopy(this.m_buffer, this.m_location, b, off + count, len - count);
                this.m_location += len - count;
                count += len - count;
                continue;
            }
            if (this.m_location + (len - count) < this.m_bufferSize) continue;
            System.arraycopy(this.m_buffer, this.m_location, b, off + count, this.m_bufferSize - this.m_location);
            if ((count += this.m_bufferSize - this.m_location) >= len) continue;
            this.readBlock();
        }
        return count;
    }

    @Override
    public final synchronized long skip(long nParam) throws IOException {
        long n = nParam;
        if (n < 0L) {
            return 0L;
        }
        while ((long)this.m_location + n > (long)this.m_bufferSize) {
            n -= (long)(this.m_bufferSize - this.m_location);
            this.readBlock();
        }
        this.m_location = (int)((long)this.m_location + n);
        return n;
    }

    @Override
    public final synchronized int available() {
        return this.m_bufferSize - this.m_location;
    }

    @Override
    public final boolean markSupported() {
        return this.m_is.markSupported();
    }

    @Override
    public final void mark(int readAheadLimit) {
        this.m_is.mark(readAheadLimit);
    }

    @Override
    public final void reset() throws IOException {
        this.m_is.reset();
    }

    @Override
    public final void close() throws IOException {
        this.m_is.close();
    }

    private void readBlock() throws IOException {
        int bytesToRead;
        int available = this.m_is.available();
        int bufferSize = this.m_buffer.length;
        if (this.m_bytesExpected > 0) {
            bytesToRead = bufferSize < this.m_bytesExpected ? bufferSize : this.m_bytesExpected;
        } else if (available > bufferSize) {
            bytesToRead = bufferSize;
        } else if (available < this.m_blockSize) {
            bytesToRead = this.m_blockSize;
        } else {
            int remainder = available % this.m_blockSize;
            bytesToRead = available - remainder;
        }
        int tempResult = 0;
        for (int result = 0; result < bytesToRead; result += tempResult) {
            tempResult = this.m_is.read(this.m_buffer, result, bytesToRead - result);
            if (tempResult != -1) continue;
            throw new EOFException();
        }
        if (this.m_key == null) {
            this.m_mp.decryptWithSessionKey(this.m_buffer, 0, bytesToRead, this.m_buffer, 0);
        } else {
            this.m_mp.decrypt(this.m_key, this.m_buffer, 0, bytesToRead, this.m_buffer, 0);
        }
        this.m_bufferSize = bytesToRead;
        if (this.m_bytesExpected != -1) {
            this.m_bytesExpected -= bytesToRead;
        }
        this.m_location = 0;
    }

    public final void bytesExpected(int count) {
        this.m_bytesExpected = count;
        this.m_location = -1;
    }
}

