/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.io.IOException;
import java.io.OutputStream;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureOutputStream;

public class SecureOutputStream
extends OutputStream
implements ISecureOutputStream {
    private static final int DEFAULT_OUTPUT_SIZE = 30720;
    private IMessageProtection m_mp;
    private byte[] m_key;
    private OutputStream m_os;
    private byte[] m_buffer;
    private int m_bufferSize;
    private int m_pos = 0;
    private int m_blockSize = 0;
    private int m_begPos = 0;

    public SecureOutputStream() {
        this.m_mp = null;
        this.m_os = null;
        this.m_key = null;
        this.m_buffer = null;
    }

    public SecureOutputStream(OutputStream os, IMessageProtection mp, byte[] buffer) {
        this.initSecureOutputStream(os, mp, buffer);
    }

    public final void initSecureOutputStream(OutputStream os, IMessageProtection mp, byte[] buffer) {
        this.m_os = os;
        this.m_mp = mp;
        this.m_key = null;
        this.m_blockSize = this.m_mp.getOutputSize(1);
        if (buffer == null) {
            this.m_buffer = new byte[30720];
            this.m_bufferSize = 30720;
        } else {
            this.m_buffer = buffer;
            this.m_bufferSize = buffer.length;
        }
    }

    public IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    public void doFinal() throws IOException {
    }

    public final OutputStream getOutputStream() {
        return this;
    }

    public final void useSessionKey() {
        this.m_key = null;
    }

    public final void setMessageKey(byte[] key) {
        this.m_key = key;
    }

    @Override
    public final void write(int b) throws IOException {
        this.checkBuffer();
        this.m_buffer[this.m_pos++] = (byte)b;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int count = 0;
        while (count < len) {
            if (this.m_pos + (len - count) < this.m_bufferSize) {
                System.arraycopy(b, off + count, this.m_buffer, this.m_pos, len - count);
                this.m_pos += len - count;
                count += len - count;
                continue;
            }
            if (this.m_pos + (len - count) < this.m_bufferSize) continue;
            System.arraycopy(b, off + count, this.m_buffer, this.m_pos, this.m_bufferSize - this.m_pos);
            count += this.m_bufferSize - this.m_pos;
            this.m_pos = this.m_bufferSize;
            this.writeBuffer();
        }
    }

    private void checkBuffer() throws IOException {
        if (this.m_pos >= this.m_bufferSize) {
            this.writeBuffer();
        }
    }

    private void writeBuffer() throws IOException {
        int pos = this.m_pos;
        int begPos = this.m_begPos;
        if (pos - begPos >= this.m_blockSize) {
            int remainder = (pos - begPos) % this.m_blockSize;
            if (remainder > 0) {
                this.m_begPos = pos = this.m_pos - remainder;
            } else {
                this.m_begPos = 0;
                this.m_pos = 0;
            }
        } else if (pos - begPos < this.m_blockSize) {
            return;
        }
        int inputLen = pos - begPos;
        if (this.m_key != null) {
            this.m_mp.encrypt(this.m_key, this.m_buffer, begPos, inputLen, this.m_buffer, begPos);
        } else {
            this.m_mp.encryptWithSessionKey(this.m_buffer, begPos, inputLen, this.m_buffer, begPos);
        }
        this.m_os.write(this.m_buffer, begPos, inputLen);
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        this.m_os.close();
    }

    @Override
    public final void flush() throws IOException {
        this.writeBuffer();
        this.m_os.flush();
    }
}

