/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xa;

import java.util.EventObject;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import progress.message.client.EAlreadyInTransaction;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotInTransaction;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETransactionAlreadyPrepared;
import progress.message.client.ETransactionFailure;
import progress.message.client.ETransactionRollbackByBroker;
import progress.message.client.EUnknownTransaction;
import progress.message.client.EUnusableConnection;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.jimpl.EventHandler;
import progress.message.jimpl.Session;
import progress.message.jimpl.SessionCloseEvent;
import progress.message.jimpl.UnacknowledgedMessagesQueue;
import progress.message.jimpl.xa.XAExceptionUtil;
import progress.message.jimpl.xa.XAResource;
import progress.message.util.DebugState;
import progress.message.xa.XidImpl;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EFlowControlException;

class TxnBranch
extends DebugObject
implements EventHandler {
    public static final int NOT_ASSOCIATED = 0;
    public static final int ASSOCIATED = 1;
    public static final int SUSPENDED = 2;
    public static final int PREPARED = 3;
    public static final int COMMITED = 4;
    public static final int ROLLBACKED = 5;
    private XidImpl m_xid;
    private int m_status;
    private int m_flags;
    private progress.message.zclient.Session m_zSession = null;
    private Session m_jSession = null;
    private UnacknowledgedMessagesQueue m_unackQueue = null;
    private XAResource m_xaRes = null;
    private boolean m_rollbackOnly = false;

    TxnBranch(XidImpl xid, int flag, progress.message.zclient.Session zSession, XAResource xaResource) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TxnBranch" : null);
        this.m_xid = xid;
        this.m_flags = flag;
        this.m_zSession = zSession;
        this.m_xaRes = xaResource;
        this.m_unackQueue = new UnacknowledgedMessagesQueue();
        this.m_status = 0;
    }

    void setFlag(int flag) {
        this.m_flags = flag;
    }

    int getFlag() {
        return this.m_flags;
    }

    int getStatus() {
        return this.m_status;
    }

    progress.message.zclient.Session getZsession() {
        return this.m_zSession;
    }

    UnacknowledgedMessagesQueue getUnacknowledgedMessagesQueue() {
        return this.m_unackQueue;
    }

    public void handleEvent(EventObject evt) {
        if (evt instanceof SessionCloseEvent) {
            this.handleSessionCloseEvent();
        }
    }

    private void handleSessionCloseEvent() {
        block3: {
            if (this.m_status == 1) {
                try {
                    this.m_xaRes.end(this.m_xid, 0x4000000);
                }
                catch (XAException e) {
                    if (!this.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    void start() throws XAException, EXADuplicateXidException {
        if (this.DEBUG) {
            XAResource.printXid(this.m_xid, "sonic");
        }
        if (this.m_zSession == null) {
            throw new XAException(-3);
        }
        if (this.m_xid == null) {
            throw new XAException(-4);
        }
        try {
            this.m_zSession.beginGlobalTransaction((Object)this.m_xid);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (EAlreadyInTransaction e) {
            throw new XAException(-6);
        }
        catch (EXADuplicateXidException e) {
            throw e;
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (EFlowControlException fcE) {
            throw XAExceptionUtil.createXAException(-3, (Exception)((Object)fcE));
        }
        catch (EGeneralException e) {
            throw new XAException(-3);
        }
        this.associateToSession();
        this.setFlag(0);
        this.m_status = 1;
    }

    void resume() throws XAException, EXAThereIsNoXidException {
        try {
            this.m_zSession.resumeGlobalTransaction((Object)this.m_xid);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (EGeneralException e) {
            throw new XAException(-3);
        }
        this.associateToSession();
        this.setFlag(0x8000000);
        this.m_status = 1;
    }

    void join() throws XAException, EXAThereIsNoXidException {
        try {
            this.m_zSession.joinGlobalTransaction((Object)this.m_xid);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (EGeneralException e) {
            throw new XAException(-3);
        }
        this.associateToSession();
        this.setFlag(0x200000);
        this.m_status = 1;
    }

    void end() throws XAException, EXAThereIsNoXidException {
        if (this.m_zSession == null) {
            throw new XAException(-3);
        }
        if (this.m_xid == null) {
            throw new XAException(-4);
        }
        if (this.m_jSession == null) {
            throw new XAException("Session not exist");
        }
        if (this.m_status == 1) {
            try {
                this.m_jSession.acknowledgeLastAsyncMsg();
            }
            catch (JMSException e) {
                throw new XAException("error when acknowledge last asyncronus received message.");
            }
        }
        this.sendJSessionBatchedMsgs();
        try {
            this.m_zSession.endGlobalTransaction((Object)this.m_xid);
        }
        catch (EParameterIsNull e) {
            throw new XAException(-4);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (ENetworkFailure e) {
            throw new XAException(-7);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        if (this.m_status == 1) {
            this.dissociateToSession();
        }
        this.setFlag(0x4000000);
        this.m_status = 0;
    }

    void suspend() throws XAException, EXAThereIsNoXidException {
        if (this.m_zSession == null) {
            throw new XAException(-3);
        }
        if (this.m_xid == null) {
            throw new XAException(-4);
        }
        try {
            if (this.m_jSession == null) {
                throw new XAException("Session not exist");
            }
            this.m_jSession.acknowledgeLastAsyncMsg();
            this.sendJSessionBatchedMsgs();
            this.m_zSession.suspendGlobalTransaction((Object)this.m_xid);
        }
        catch (EParameterIsNull e) {
            throw new XAException(-4);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (ENetworkFailure e) {
            throw new XAException(-7);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (JMSException e) {
            throw new XAException("error when acknowledge last asyncronus received message.");
        }
        this.dissociateToSession();
        this.setFlag(0x2000000);
        this.m_status = 2;
    }

    void fail() throws XAException, EXAThereIsNoXidException {
        if (this.m_status == 1) {
            this.dissociateToSession();
        }
        this.setFlag(0x20000000);
        this.m_status = 0;
        this.rollback();
        this.m_rollbackOnly = true;
    }

    boolean isRollbackOnly() {
        return this.m_rollbackOnly;
    }

    void prepare() throws XAException, EXAThereIsNoXidException {
        if (this.m_status == 5) {
            throw new XAException(100);
        }
        if (this.m_status == 1) {
            throw new XAException("XAResource.prepare is invoked before XAResource.end is invoked.");
        }
        if (this.m_zSession == null) {
            throw new XAException(-3);
        }
        if (this.m_xid == null) {
            throw new XAException(-4);
        }
        try {
            this.m_zSession.prepareWork((Object)this.m_xid);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (ENotInTransaction e) {
            throw new XAException(-6);
        }
        catch (ETransactionAlreadyPrepared e) {
            throw new XAException(-6);
        }
        catch (ETransactionRollbackByBroker e) {
            throw new XAException(100);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (ENetworkFailure e) {
            throw new XAException(-7);
        }
        catch (ESecurityPolicyViolation e) {
            throw new XAException(-6);
        }
        catch (EGeneralException e) {
            throw new XAException(-3);
        }
        this.m_status = 3;
    }

    void commit(boolean onePhase) throws XAException, EXAThereIsNoXidException {
        if (this.m_xid == null) {
            throw new XAException(-4);
        }
        switch (this.m_status) {
            case 1: {
                throw new XAException("XAResource.commit should not be invoked after start method consecutively.");
            }
            case 0: 
            case 2: {
                if (onePhase) break;
                throw new XAException("Should not do two phase commit before prepare.");
            }
            case 3: {
                if (!onePhase) break;
                throw new XAException("Should not do one phase commit after prepare.");
            }
            case 4: {
                return;
            }
            case 5: {
                throw new XAException("transaction(" + this.m_xid + ") was already rolled back.");
            }
        }
        if (this.m_zSession == null) {
            throw new XAException(-3);
        }
        this.m_unackQueue.removeAllMessages();
        try {
            this.m_zSession.commitWork(false, (Object)this.m_xid);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (ENotInTransaction e) {
            throw new XAException(-6);
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (EUnknownTransaction e) {
            throw new XAException(-6);
        }
        catch (ETransactionRollbackByBroker e) {
            throw new XAException(100);
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (ENetworkFailure e) {
            throw new XAException(-7);
        }
        catch (ESecurityPolicyViolation e) {
            throw new XAException(-6);
        }
        catch (EGeneralException e) {
            throw new XAException(-3);
        }
        this.m_status = 4;
    }

    void rollback() throws XAException, EXAThereIsNoXidException {
        if (this.isRollbackOnly()) {
            return;
        }
        if (this.m_xid == null) {
            throw new XAException(-4);
        }
        switch (this.m_status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                throw new XAException("transaction(" + this.m_xid + ") has been commited");
            }
            case 5: {
                return;
            }
        }
        if (this.m_zSession == null) {
            throw new XAException(-3);
        }
        LinkedList ccMsgs = new LinkedList();
        LinkedList nonCCMsgs = new LinkedList();
        this.m_unackQueue.removeAllMessages(ccMsgs, nonCCMsgs);
        if (this.m_jSession != null && !this.m_jSession.isClosing()) {
            this.m_jSession.recoverReceivedMessageQueue(ccMsgs, nonCCMsgs);
            try {
                this.m_jSession.rollbackBatch();
            }
            catch (JMSException e) {
                throw new XAException(-3);
            }
        }
        try {
            this.m_zSession.rollbackWork(false, (Object)this.m_xid);
        }
        catch (EXAThereIsNoXidException e) {
            throw e;
        }
        catch (EUnusableConnection e) {
            throw new XAException(-7);
        }
        catch (EUnknownTransaction e) {
            throw new XAException(-6);
        }
        catch (ETransactionFailure e) {
            throw new XAException(-3);
        }
        catch (ENetworkFailure e) {
            throw new XAException(-7);
        }
        catch (ESecurityPolicyViolation e) {
            throw new XAException(-6);
        }
        catch (EGeneralException e) {
            throw new XAException(-3);
        }
        this.m_status = 5;
    }

    void recover(int flag) throws XAException {
        this.setFlag(flag);
        this.m_status = 3;
    }

    void close() {
        switch (this.m_status) {
            case 0: {
                break;
            }
            case 1: {
                this.dissociateToSession();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        this.m_zSession.close();
        this.m_zSession = null;
        this.m_xaRes = null;
    }

    private void associateToSession() throws XAException {
        if (this.m_jSession == null || this.m_jSession.isClosing()) {
            this.m_jSession = this.m_xaRes.getJsession();
        }
        this.m_jSession.associateToXAtxn(this.getZsession(), this.getUnacknowledgedMessagesQueue());
        this.m_jSession.addEventHandler((EventHandler)this);
    }

    private void dissociateToSession() {
        if (this.m_jSession == null) {
            return;
        }
        this.m_jSession.dissociateToXAtxn();
        this.m_jSession.removeEventHandler((EventHandler)this);
    }

    private void sendJSessionBatchedMsgs() throws XAException {
        if (this.m_jSession != null && !this.m_jSession.isClosing()) {
            try {
                this.m_jSession.sendJSessionBatchedMsgs();
            }
            catch (JMSException e) {
                if (this.DEBUG) {
                    e.printStackTrace();
                }
                throw XAExceptionUtil.createXAException(-3, (Exception)((Object)e));
            }
        }
    }
}

