/*
 * Decompiled with CFR 0.152.
 */
package progress.message.xa;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.transaction.xa.Xid;
import progress.message.util.ArrayUtil;
import progress.message.util.StreamUtil;

public class XidImpl
implements Xid,
Cloneable,
Serializable {
    static final long serialVersionUID = -5363901495878210611L;
    private int m_formatID = -1;
    private byte[] m_gtrid;
    private int m_gtridLength;
    private byte[] m_bqual;
    private int m_bqualLength;

    public XidImpl() {
        this(-1, null, null);
    }

    public XidImpl(int formatID, byte[] globalTxnID, byte[] branchID) {
        this.m_formatID = formatID;
        this.setGlobalTransactionId(globalTxnID);
        this.setBranchQualifier(branchID);
    }

    public XidImpl(Xid from) {
        if (from == null || from.getFormatId() == -1) {
            this.m_formatID = -1;
            this.setGlobalTransactionId(null);
            this.setBranchQualifier(null);
        } else {
            this.m_formatID = from.getFormatId();
            this.setGlobalTransactionId(from.getGlobalTransactionId());
            this.setBranchQualifier(from.getBranchQualifier());
        }
    }

    public XidImpl(String globalTxnId, String branchId) {
        this(99, globalTxnId.getBytes(), branchId.getBytes());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Xid other = (Xid)o;
        if (this.m_formatID == -1 && other.getFormatId() == -1) {
            return true;
        }
        if (this.m_formatID != other.getFormatId() || this.m_gtridLength != other.getGlobalTransactionId().length || this.m_bqualLength != other.getBranchQualifier().length) {
            return false;
        }
        return this.isEqualGtrid(other) && this.isEqualBranchQualifier(other.getBranchQualifier());
    }

    public int hashCode() {
        if (this.m_formatID == -1) {
            return -1;
        }
        return this.m_formatID + this.m_gtridLength - this.m_bqualLength;
    }

    public String toString() {
        String gtString = new String(this.getGlobalTransactionId());
        String brString = new String(this.getBranchQualifier());
        return new String("{Xid: formatID=" + this.m_formatID + ", gtrid[" + this.m_gtridLength + "]=" + gtString + ", brid[" + this.m_bqualLength + "]=" + brString + "}");
    }

    @Override
    public int getFormatId() {
        return this.m_formatID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.m_gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.m_bqual;
    }

    private void setBranchQualifier(byte[] branchID) {
        if (branchID == null) {
            this.m_bqualLength = 0;
            this.m_bqual = new byte[this.m_bqualLength];
        } else {
            this.m_bqualLength = branchID.length > 64 ? 64 : branchID.length;
            this.m_bqual = new byte[this.m_bqualLength];
            System.arraycopy(branchID, 0, this.m_bqual, 0, this.m_bqualLength);
        }
    }

    private void setGlobalTransactionId(byte[] globalTxnID) {
        if (globalTxnID == null) {
            this.m_gtridLength = 0;
            this.m_gtrid = new byte[this.m_gtridLength];
        } else {
            this.m_gtridLength = globalTxnID.length > 64 ? 64 : globalTxnID.length;
            this.m_gtrid = new byte[this.m_gtridLength];
            System.arraycopy(globalTxnID, 0, this.m_gtrid, 0, this.m_gtridLength);
        }
    }

    private void setFormatID(int formatID) {
        this.m_formatID = formatID;
    }

    private boolean isEqualGtrid(Xid xid) {
        byte[] xidGtrid = xid.getGlobalTransactionId();
        if (this.getGlobalTransactionId() == null && xidGtrid == null) {
            return true;
        }
        if (this.getGlobalTransactionId() == null) {
            return false;
        }
        if (xidGtrid == null) {
            return false;
        }
        if (this.m_gtridLength != xidGtrid.length) {
            return false;
        }
        for (int i = 0; i < this.m_gtridLength; ++i) {
            if (this.m_gtrid[i] == xidGtrid[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualBranchQualifier(byte[] data) {
        int L;
        int n = L = data.length > 64 ? 64 : data.length;
        if (L != this.m_bqualLength) {
            return false;
        }
        for (int i = 0; i < this.m_bqualLength; ++i) {
            if (data[i] == this.m_bqual[i]) continue;
            return false;
        }
        return true;
    }

    public int getMemorySize() {
        return 8 + this.m_gtridLength + 4 + this.m_bqualLength;
    }

    public void writebody(OutputStream out) throws IOException {
        StreamUtil.writeInt((int)this.m_formatID, (OutputStream)out);
        StreamUtil.writeInt((int)this.m_gtridLength, (OutputStream)out);
        out.write(this.getGlobalTransactionId(), 0, this.m_gtridLength);
        StreamUtil.writeInt((int)this.m_bqualLength, (OutputStream)out);
        out.write(this.getBranchQualifier(), 0, this.m_bqualLength);
    }

    public void writebody(DataOutput out) throws IOException {
        out.writeInt(this.m_formatID);
        out.writeInt(this.m_gtridLength);
        out.write(this.getGlobalTransactionId(), 0, this.m_gtridLength);
        out.writeInt(this.m_bqualLength);
        out.write(this.getBranchQualifier(), 0, this.m_bqualLength);
    }

    public int writebody(byte[] out, int off) {
        ArrayUtil.writeInt((byte[])out, (int)off, (int)this.m_formatID);
        ArrayUtil.writeInt((byte[])out, (int)(off += 4), (int)this.m_gtridLength);
        System.arraycopy(this.getGlobalTransactionId(), 0, out, off += 4, this.m_gtridLength);
        ArrayUtil.writeInt((byte[])out, (int)(off += this.m_gtridLength), (int)this.m_bqualLength);
        System.arraycopy(this.getBranchQualifier(), 0, out, off += 4, this.m_bqualLength);
        return off += this.m_bqualLength;
    }

    public void readbody(InputStream in) throws IOException {
        this.m_formatID = StreamUtil.readInt((InputStream)in);
        int gtidLen = StreamUtil.readInt((InputStream)in);
        byte[] globalTxnId = new byte[gtidLen];
        StreamUtil.readBytes((InputStream)in, (byte[])globalTxnId, (int)0, (int)gtidLen);
        int brlen = StreamUtil.readInt((InputStream)in);
        byte[] branchId = new byte[brlen];
        StreamUtil.readBytes((InputStream)in, (byte[])branchId, (int)0, (int)brlen);
        this.setGlobalTransactionId(globalTxnId);
        this.setBranchQualifier(branchId);
    }

    public int readbody(byte[] in, int off) {
        this.m_formatID = ArrayUtil.readInt((byte[])in, (int)off);
        int gtidLen = ArrayUtil.readInt((byte[])in, (int)(off += 4));
        byte[] globalTxnId = new byte[gtidLen];
        System.arraycopy(in, off += 4, globalTxnId, 0, gtidLen);
        int brlen = ArrayUtil.readInt((byte[])in, (int)(off += gtidLen));
        byte[] branchId = new byte[brlen];
        System.arraycopy(in, off += 4, branchId, 0, brlen);
        this.setGlobalTransactionId(globalTxnId);
        this.setBranchQualifier(branchId);
        return off += brlen;
    }

    public void readbody(DataInput in) throws IOException {
        this.m_formatID = in.readInt();
        int gtidLen = in.readInt();
        byte[] globalTxnId = new byte[gtidLen];
        in.readFully(globalTxnId, 0, gtidLen);
        int brlen = in.readInt();
        byte[] branchId = new byte[brlen];
        in.readFully(branchId, 0, brlen);
        this.setGlobalTransactionId(globalTxnId);
        this.setBranchQualifier(branchId);
    }
}

