/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient.xa;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.naming.NamingException;
import javax.naming.Reference;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.JMSExceptionUtils;
import progress.message.jclient.xa.XAJMSContext;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.net.ProgressInetAddress;

public class XAConnectionFactory
extends ConnectionFactory
implements javax.jms.XAConnectionFactory {
    static final long serialVersionUID = 2997858615851806114L;

    public XAConnectionFactory() throws JMSException {
        this(ProgressInetAddress.getLocalHostName());
    }

    public XAConnectionFactory(String brokerlist) throws JMSException {
        super(brokerlist, "", "");
    }

    public XAConnectionFactory(String brokerlist, String connectID, String userName, String password) throws JMSException {
        super(brokerlist, connectID, userName, password);
    }

    protected XAConnectionFactory(Hashtable env) throws JMSException {
        super(env);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(this.getDefaultUser() == null ? "" : this.getDefaultUser(), this.getDefaultPassword() == null ? "" : this.getDefaultPassword());
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (this.getLoadBalancing()) {
            throw JMSExceptionUtil.createJMSException((String)"load-balancing should not be turned on for XA client.", null);
        }
        this.checkSPILoginBind();
        this.resolveConnectionURLs();
        return new progress.message.jimpl.xa.XAConnection(this.getConnectID(), userName, password, this, this.env);
    }

    public javax.jms.XAJMSContext createXAContext() {
        try {
            return new XAJMSContext(this.createXAConnection(), 0);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException((JMSException)e);
        }
    }

    public javax.jms.XAJMSContext createXAContext(String userName, String password) {
        try {
            return new XAJMSContext(this.createXAConnection(userName, password), 0);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException((JMSException)e);
        }
    }

    public String getUserName() {
        return this.getDefaultUser();
    }

    public String getPassword() {
        return this.getDefaultPassword();
    }

    public void setUserName(String username) {
        this.setDefaultUser(username);
    }

    public void setPassword(String password) {
        this.setDefaultPassword(password);
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(XAConnectionFactory.class.getName(), AdministeredObjectFactory.class.getName(), null);
        this.addReferences(ref);
        return ref;
    }
}

