/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import progress.message.client.ENetworkFailure;
import progress.message.client.ETransactionFailure;
import progress.message.client.EUnusableConnection;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.jimpl.Session;
import progress.message.jimpl.UnacknowledgedMessagesQueue;
import progress.message.jimpl.xa.TxnBranch;
import progress.message.jimpl.xa.XASession;
import progress.message.util.DebugState;
import progress.message.xa.TxnInfo;
import progress.message.xa.XidImpl;
import progress.message.zclient.DebugObject;

public class XAResource
extends DebugObject
implements javax.transaction.xa.XAResource {
    private volatile Boolean ALREADY_CLOSED = new Boolean(false);
    private final Object lockObj = new Object();
    private static final int T0_NOT_ASSOCIATED = 0;
    private static final int T1_ASSOCIATED = 1;
    private static final int T2_ASSOC_SUSPENDED = 2;
    private transient Hashtable m_transBranches = new Hashtable();
    private transient XASession m_xaSession = null;
    private transient progress.message.zclient.Session m_comSession = null;
    private int m_XAResourceTransactionState = 0;
    private boolean m_recoveryScanStarted = false;

    XAResource(XASession xaSession) throws XAException {
        super(DebugState.GLOBAL_DEBUG_ON ? "XAResource" : null);
        this.m_xaSession = xaSession;
        this.m_comSession = this.createZsession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid theXid, int flags) throws XAException {
        if (this.DEBUG) {
            this.debug("start()");
            this.debugXid(theXid, "start()");
            this.debugFlag(flags);
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        XidImpl xid = new XidImpl(theXid);
        TxnBranch txnBranch = null;
        switch (flags) {
            case 0: {
                if (this.m_XAResourceTransactionState != 0) {
                    throw new XAException("TMNOFLAGS: XAResource.start is invoked on a connection that is currently associated with a different transaction. XAResource Transaction State is T" + this.m_XAResourceTransactionState);
                }
                if (this.hasXid(xid)) {
                    throw new XAException(-8);
                }
                progress.message.zclient.Session zSession = this.createZsession();
                txnBranch = new TxnBranch(xid, 0, zSession, this);
                try {
                    txnBranch.start();
                    this.registerTxnBranch(xid, txnBranch);
                }
                catch (EXADuplicateXidException e) {
                    txnBranch.close();
                    throw this.createXAExceptionXaerDupid(e);
                }
                this.m_XAResourceTransactionState = 1;
                break;
            }
            case 0x200000: {
                if (this.m_XAResourceTransactionState != 0) {
                    throw new XAException("TMJOIN: XAResource.start is invoked on a connection that is currently associated with a different transaction. XAResource Transaction State is T" + this.m_XAResourceTransactionState);
                }
                if (!this.hasXid(xid)) {
                    throw new XAException(-4);
                }
                txnBranch = this.getTxnBranch(xid);
                if (txnBranch == null) {
                    throw new XAException(-6);
                }
                try {
                    txnBranch.join();
                }
                catch (EXAThereIsNoXidException e) {
                    txnBranch.close();
                    throw this.createXAException(e);
                }
                this.m_XAResourceTransactionState = 1;
                break;
            }
            case 0x8000000: {
                if (this.m_XAResourceTransactionState != 2) {
                    throw new XAException("TMJOIN: XAResource.start is not invoked on a Suspended Association. XAResource Transaction State is T" + this.m_XAResourceTransactionState);
                }
                if (!this.hasXid(xid)) {
                    throw new XAException(-4);
                }
                txnBranch = this.getTxnBranch(xid);
                if (txnBranch == null) {
                    throw new XAException(-6);
                }
                try {
                    txnBranch.resume();
                }
                catch (EXAThereIsNoXidException e) {
                    txnBranch.close();
                    throw this.createXAException(e);
                }
                this.m_XAResourceTransactionState = 1;
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid theXid, int flags) throws XAException {
        if (this.DEBUG) {
            this.debug("end()");
            this.debugXid(theXid, "end()");
            this.debugFlag(flags);
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        XidImpl xid = this.createXidAndVerify(theXid);
        TxnBranch txnBranch = this.getAndCheckTxnBranch(xid);
        try {
            switch (flags) {
                case 0x4000000: {
                    if (this.m_XAResourceTransactionState == 0) {
                        throw new XAException("TMSUCCESS: XAResource.end is invoked when transaction is not Associated. XAResource Transaction State is T0.");
                    }
                    txnBranch.end();
                    this.m_XAResourceTransactionState = 0;
                    break;
                }
                case 0x2000000: {
                    if (this.m_XAResourceTransactionState != 1) {
                        throw new XAException("TMSUSPEND: XAResource.end is invoked when transaction is not Associated or Association Suspended. XAResource Transaction State is T" + this.m_XAResourceTransactionState);
                    }
                    txnBranch.suspend();
                    this.m_XAResourceTransactionState = 2;
                    break;
                }
                case 0x20000000: {
                    if (this.m_XAResourceTransactionState == 0) {
                        throw new XAException("TMFAIL: XAResource.end is invoked when transaction is not Associated. XAResource Transaction State is T0.");
                    }
                    txnBranch.fail();
                    this.m_XAResourceTransactionState = 0;
                    break;
                }
                default: {
                    throw new XAException(-5);
                }
            }
        }
        catch (EXAThereIsNoXidException e) {
            throw this.createXAException(e);
        }
    }

    private XAException createXAException(EXAThereIsNoXidException e) {
        if (this.DEBUG) {
            e.printStackTrace();
        }
        return new XAException(-4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid theXid, boolean onePhase) throws XAException {
        if (this.DEBUG) {
            this.debug("commit() onePhase=" + onePhase);
            this.debugXid(theXid, "commit()");
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        XidImpl xid = this.createXidAndVerify(theXid);
        try {
            TxnBranch txnBranch = this.getAndCheckTxnBranch(xid);
            txnBranch.commit(onePhase);
        }
        catch (EXAThereIsNoXidException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 3: {
                    break;
                }
                case 100: {
                    if (onePhase) {
                        this.cleanupResources(xid);
                        if (this.DEBUG) {
                            e.printStackTrace();
                        }
                        throw e;
                    }
                    if (this.DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
                default: {
                    if (this.DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
        }
        this.cleanupResources(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid theXid) throws XAException {
        if (this.DEBUG) {
            this.debug("prepare()");
            this.debugXid(theXid, "prepare()");
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        XidImpl xid = this.createXidAndVerify(theXid);
        try {
            TxnBranch txnBranch = this.getAndCheckTxnBranch(xid);
            txnBranch.prepare();
        }
        catch (EXAThereIsNoXidException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
        }
        catch (XAException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            if (e.errorCode == 3) {
                this.cleanupResources(xid);
                return 3;
            }
            throw e;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback(Xid theXid) throws XAException {
        if (this.DEBUG) {
            this.debug("rollback()");
            this.debugXid(theXid, "rollback()");
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        XidImpl xid = this.createXidAndVerify(theXid);
        TxnBranch txnBranch = this.getAndCheckTxnBranch(xid);
        try {
            txnBranch.rollback();
            return;
        }
        catch (EXAThereIsNoXidException e) {
            if (!this.DEBUG) return;
            e.printStackTrace();
            return;
        }
        catch (XAException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            switch (e.errorCode) {
                case 3: {
                    return;
                }
                case 100: {
                    return;
                }
                default: {
                    throw e;
                }
            }
        }
        finally {
            this.cleanupResources(xid);
        }
    }

    private TxnBranch getAndCheckTxnBranch(XidImpl xid) throws XAException {
        TxnBranch txnBranch = this.getTxnBranch(xid);
        if (txnBranch == null) {
            throw new XAException(-6);
        }
        return txnBranch;
    }

    private XidImpl createXidAndVerify(Xid theXid) throws XAException {
        XidImpl xid = new XidImpl(theXid);
        if (!this.hasXid(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid theXid) throws XAException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        XidImpl xid = new XidImpl(theXid);
        throw new XAException("forget() is not supported yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        Vector txnInfos;
        if (this.DEBUG) {
            this.debug("recover()");
            this.debugFlag(flag);
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        if (this.m_recoveryScanStarted && flag == 0) {
            return new XidImpl[0];
        }
        if (this.m_recoveryScanStarted && flag == 0x800000) {
            this.m_recoveryScanStarted = false;
            return new XidImpl[0];
        }
        try {
            txnInfos = this.m_comSession.getPreparedGlobalTransactions();
        }
        catch (ETransactionFailure e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            throw new XAException(-3);
        }
        catch (EUnusableConnection e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            throw new XAException(-7);
        }
        catch (ENetworkFailure e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            throw new XAException(-7);
        }
        Object[] ret = null;
        if (txnInfos == null) {
            ret = new XidImpl[]{};
        } else {
            int len = txnInfos.size();
            Session jSession = this.getJsession();
            for (int i = 0; i < len; ++i) {
                TxnInfo txnInfo = (TxnInfo)txnInfos.elementAt(i);
                if (this.hasXid(txnInfo)) continue;
                progress.message.zclient.Session zSession = this.createZsession(txnInfo.getTid());
                TxnBranch txnBranch = new TxnBranch(txnInfo, flag, zSession, this);
                txnBranch.recover(flag);
                try {
                    this.registerTxnBranch(txnInfo, txnBranch);
                    continue;
                }
                catch (EXADuplicateXidException e) {
                    txnBranch.close();
                    throw this.createXAExceptionXaerDupid(e);
                }
            }
            ret = new XidImpl[len];
            txnInfos.copyInto(ret);
        }
        if (flag == 0x1000000) {
            this.m_recoveryScanStarted = true;
        }
        if ((flag & 0x800000) == 0x800000) {
            this.m_recoveryScanStarted = false;
        }
        return ret;
    }

    private XAException createXAExceptionXaerDupid(EXADuplicateXidException e) {
        if (this.DEBUG) {
            e.printStackTrace();
        }
        return new XAException(-8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameRM(javax.transaction.xa.XAResource xares) throws XAException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        return xares.equals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.DEBUG) {
            this.debug("setTransactionTimeout() seconds=" + seconds);
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionTimeout() throws XAException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lockObj;
        synchronized (object) {
            this.ALREADY_CLOSED = new Boolean(true);
            this.closeTxnBranches();
        }
        this.closeComSession();
        this.m_xaSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTxnBranches() {
        if (this.m_transBranches == null) {
            return;
        }
        Hashtable hashtable = this.m_transBranches;
        synchronized (hashtable) {
            Enumeration xids = this.m_transBranches.keys();
            while (xids.hasMoreElements()) {
                Xid xid = (Xid)xids.nextElement();
                ((TxnBranch)((Object)this.m_transBranches.get(xid))).close();
                this.m_transBranches.remove(xid);
            }
        }
    }

    private void closeComSession() {
        this.m_comSession = null;
    }

    Session getJsession() throws XAException {
        Session jSession;
        block6: {
            if (this.m_xaSession == null) {
                throw new XAException(-9);
            }
            jSession = null;
            try {
                if (this.m_xaSession instanceof XAQueueSession) {
                    jSession = (Session)((XAQueueSession)this.m_xaSession).getQueueSession();
                    break block6;
                }
                if (this.m_xaSession instanceof XATopicSession) {
                    jSession = (Session)((XATopicSession)this.m_xaSession).getTopicSession();
                    break block6;
                }
                if (this.m_xaSession instanceof javax.jms.XASession) {
                    jSession = (Session)this.m_xaSession.getSession();
                    break block6;
                }
                throw new XAException("m_xaSession is a wrong type: " + this.m_xaSession.getClass().getName());
            }
            catch (JMSException je) {
                throw new XAException("fail to get jSession because of the JMSException");
            }
        }
        return jSession;
    }

    private TxnBranch getTxnBranch(Xid xid) {
        return (TxnBranch)((Object)this.m_transBranches.get(xid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasXid(XidImpl xid) throws XAException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.ALREADY_CLOSED.booleanValue()) {
                throw new XAException(-7);
            }
            return this.m_transBranches.containsKey(xid);
        }
    }

    private void registerTxnBranch(XidImpl xid, TxnBranch txnBranch) throws EXADuplicateXidException {
        if (this.m_transBranches.containsKey(xid)) {
            throw new EXADuplicateXidException("registerTxnBranch: " + xid.toString());
        }
        this.m_transBranches.put(xid, txnBranch);
        if (this.DEBUG) {
            System.out.println("txnBranch registry: " + this.m_transBranches.toString());
        }
    }

    private void unregisterTxnBranch(Xid xid) {
        this.getTxnBranch(xid).close();
        this.m_transBranches.remove(xid);
    }

    private int getFlag(XidImpl xid) throws XAException {
        TxnBranch txnBranch = this.retrieveTxnBranch(xid);
        return txnBranch.getFlag();
    }

    private UnacknowledgedMessagesQueue getUnacknowledgedMessagesQueue(Xid xid) throws XAException {
        TxnBranch txnBranch = this.retrieveTxnBranch(xid);
        return txnBranch.getUnacknowledgedMessagesQueue();
    }

    private progress.message.zclient.Session getZsession(Xid xid) throws XAException {
        TxnBranch txnBranch = this.retrieveTxnBranch(xid);
        return txnBranch.getZsession();
    }

    private <T0 extends Xid> TxnBranch retrieveTxnBranch(T0 xid) throws XAException {
        TxnBranch txnBranch = this.getTxnBranch(xid);
        if (txnBranch == null) {
            throw new XAException("null txnBranch for existing xid");
        }
        return txnBranch;
    }

    private progress.message.zclient.Session createZsession() throws XAException {
        progress.message.zclient.Session zSession;
        try {
            zSession = this.m_xaSession.createGTzsession();
        }
        catch (JMSException e) {
            throw new XAException(-3);
        }
        return zSession;
    }

    private progress.message.zclient.Session createZsession(int tid) throws XAException {
        progress.message.zclient.Session zSession;
        try {
            zSession = this.m_xaSession.createGTzsession(tid);
        }
        catch (JMSException e) {
            throw new XAException(-3);
        }
        return zSession;
    }

    private void cleanupResources(XidImpl xid) {
        this.unregisterTxnBranch(xid);
        this.m_XAResourceTransactionState = 0;
    }

    String getObjectRefString() {
        return Integer.toHexString(this.hashCode());
    }

    void debugFlag(int flag) {
        this.debug(XAResource.getFlagString(flag));
    }

    void debugXid(Xid theXid, String comment) {
        this.debug(comment + " Xid = " + XAResource.getXidString(theXid));
    }

    static void printXid(Xid theXid, String comment) {
        System.out.println(comment + " Xid = " + XAResource.getXidString(theXid));
    }

    static void printFlag(int flag) {
        System.out.println(XAResource.getFlagString(flag));
    }

    static String getFlagString(int flag) {
        switch (flag) {
            case 0x20000000: {
                return "flag = TMFAIL";
            }
            case 0x200000: {
                return "flag = TMJOIN";
            }
            case 0: {
                return "flag = TMNOFLAGS";
            }
            case 0x40000000: {
                return "flag = TMONEPHASE";
            }
            case 0x8000000: {
                return "flag = TMRESUME";
            }
            case 0x1000000: {
                return "flag = TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "flag = TMSUCCESS";
            }
            case 0x2000000: {
                return "flag = TMSUSPEND";
            }
        }
        return "flag is unknown";
    }

    static String getXidString(Xid theXid) {
        String gtString = new String(theXid.getGlobalTransactionId());
        int gtLen = theXid.getGlobalTransactionId().length;
        String brString = new String(theXid.getBranchQualifier());
        int brLen = theXid.getBranchQualifier().length;
        return "{Xid: formatID=" + theXid.getFormatId() + ", gtrid[" + gtLen + "] = " + gtString + ", brid[" + brLen + "] = " + brString + "}";
    }

    protected String getDebugMessagePrefix() {
        return this.getObjectRefString() + ": ";
    }
}

