/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.TextMessage;
import progress.message.jimpl.xmessage.XMLdomMessage;
import progress.message.jimpl.xmessage.XMLdomMessageImpl;
import progress.message.zclient.Envelope;

public class XMLMessage
extends TextMessage
implements progress.message.jclient.XMLMessage {
    private int m_xmlModel = 0;
    private XMLdomMessage m_dom = null;
    private String m_XMLdomMessageClassname = "progress.message.jimpl.xmessage.XMLdomMessageImpl";
    private static final String DEFAULT_SAX_PARSER = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
    private String m_SAXParserFactory;
    private static final int XML_TEXT = 0;
    private static final int XML_DOM = 1;
    private static final int XML_SAX = 2;
    private boolean m_namespaceAware = false;

    public XMLMessage() {
        this.m_zenvelope.setBodyType((short)7);
    }

    XMLMessage(Envelope envelope) {
        super(envelope);
    }

    public Object clone() {
        XMLMessage msg = (XMLMessage)((Object)super.clone());
        this.setXmlModel(0);
        return msg;
    }

    public void clearBody() throws JMSException {
        this.setXmlModel(0);
        super.clearBody();
    }

    public void setText(String string) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_zenvelope.getMessage().setBody(null);
            this.m_zenvelope.getMessage().writeUTF(string);
            this.setXmlModel(0);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException((Exception)e);
        }
    }

    public String getText() throws JMSException {
        if (this.getXmlModel() == 1) {
            this.marshal();
        }
        return super.getText();
    }

    public void marshal() throws JMSException, MessageNotWriteableException {
        if (this.getXmlModel() == 1) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.m_dom.marshal(bout);
                String string = bout.toString("UTF-8");
                this.m_zenvelope.getMessage().setBody(null);
                this.m_zenvelope.getMessage().writeUTF(string);
            }
            catch (IOException e) {
                throw JMSExceptionUtil.createJMSException((Exception)e);
            }
        }
    }

    private void setXmlModel(int model) {
        this.m_xmlModel = model;
        if (model != 1 && this.m_dom != null) {
            this.m_dom = null;
        }
    }

    private int getXmlModel() {
        return this.m_xmlModel;
    }

    public Document getDocument() throws JMSException {
        if (this.getXmlModel() == 1 && this.m_dom.isNamespaceAware() == this.m_namespaceAware) {
            return this.m_dom.getDocument();
        }
        String body = null;
        try {
            body = this.seekToBeginning();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException((Exception)e);
        }
        try {
            this.m_dom = this.createXMLdomMessage();
            this.m_dom.setNamespaceAware(this.m_namespaceAware);
            if (body != null) {
                ByteArrayInputStream l_bis = new ByteArrayInputStream(body.getBytes("UTF-8"));
                this.m_dom.parse(l_bis);
            }
            this.m_zenvelope.getMessage().setBody(null);
            this.setXmlModel(1);
            return this.m_dom.getDocument();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"XMLMESSAGE_002"), (Exception)e);
        }
    }

    public void setDocument(Document aDoc) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        this.m_zenvelope.getMessage().setBody(null);
        if (this.getXmlModel() != 1) {
            this.m_dom = this.createXMLdomMessage();
            this.setXmlModel(1);
        }
        this.m_dom.setDocument(aDoc);
    }

    public void setNamespaceAware(boolean aware) {
        this.m_namespaceAware = aware;
    }

    public boolean isNamespaceAware() {
        return this.m_namespaceAware;
    }

    private XMLdomMessage createXMLdomMessage() throws JMSException {
        try {
            Class<?> c = Class.forName(this.m_XMLdomMessageClassname);
            return (XMLdomMessage)c.newInstance();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"XMLMESSAGE_005"), (Exception)e);
        }
    }

    public void setXMLdomMessageClassname(String classname) throws JMSException {
        if (this.getXmlModel() == 1) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"XMLMESSAGE_006"), null);
        }
        this.m_XMLdomMessageClassname = classname;
    }

    public String getXMLdomMessageClassname() {
        return this.m_XMLdomMessageClassname;
    }

    public InputSource getSAXInputSource() throws JMSException {
        if (!this.m_bodyReadOnly) {
            throw new MessageNotReadableException("");
        }
        InputSource saxInputsrc = null;
        ByteArrayInputStream l_bis = null;
        String body = null;
        try {
            body = this.seekToBeginning();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"XMLMESSAGE_007"), (Exception)e);
        }
        if (body == null) {
            return null;
        }
        try {
            l_bis = new ByteArrayInputStream(body.getBytes("UTF-8"));
            saxInputsrc = new InputSource(l_bis);
            this.setXmlModel(2);
            if (this.getSAXParserFactory() == null) {
                this.setSAXParserFactory(DEFAULT_SAX_PARSER);
            }
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"XMLMESSAGE_008"), (Exception)e);
        }
        return saxInputsrc;
    }

    private String seekToBeginning() throws IOException, JMSException {
        if (this.m_zenvelope.getMessage().cap() != 0) {
            this.m_zenvelope.getMessage().gotoByte(0);
        }
        return this.getText();
    }

    public String getDocumentBuilderFactory() {
        this.initMDom();
        return this.m_dom.getDocumentBuilderFactory();
    }

    public void setDocumentBuilderFactory(String classname) {
        this.initMDom();
        this.m_dom.setDocumentBuilderFactory(classname);
    }

    private void initMDom() {
        if (this.m_dom == null) {
            this.m_dom = new XMLdomMessageImpl();
        }
    }

    public String getSAXParserFactory() {
        if (this.m_SAXParserFactory != null) {
            return this.m_SAXParserFactory;
        }
        this.m_SAXParserFactory = System.getProperty("javax.xml.parsers.SAXParserFactory");
        return this.m_SAXParserFactory;
    }

    public void setSAXParserFactory(String classname) throws JMSException {
        this.m_SAXParserFactory = classname;
    }
}

