/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils;

import com.progress.sonic.utilities.esb.admin.ESBAdmin;
import com.progress.sonic.utilities.mfutils.JMXAdmin;
import com.progress.sonic.utilities.mfutils.NullArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.jndi.mfcontext.MFContextFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mq.mgmtapi.config.MQMgmtBeanFactory;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import com.sonicsw.xqimpl.mgmtapi.config.XQMgmtBeanFactory;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public final class MFUtils {
    private static final int TIMEOUT = 10000;
    private String domain_ = "Domain1";
    private String url_ = "tcp://localhost:2506";
    private String user_ = "Administrator";
    private String pwd_ = "Administrator";
    private MQMgmtBeanFactory mqMgmtBeanFactory_ = null;
    private MFMgmtBeanFactory mgmtBeanFactory_ = null;
    private XQMgmtBeanFactory xqMgtmFactory_ = null;
    private DSArtifactStorage dsStore_ = null;
    private Context context_ = null;
    private ESBAdmin esbAdmin_ = null;
    private JMXAdmin jmxAdmin_ = null;

    public MFUtils() {
    }

    public final void finalize() {
        this.cleanup();
    }

    public final String getUrl() {
        return this.url_;
    }

    public final String getDomain() {
        return this.domain_;
    }

    public final String getUser() {
        return this.user_;
    }

    public final String getPassword() {
        return this.pwd_;
    }

    public MFUtils(String _domain, String _url, String _user, String _password) {
        this.domain_ = _domain;
        this.url_ = _url;
        this.user_ = _user;
        this.pwd_ = _password;
    }

    public final MQMgmtBeanFactory getMQBeanFactory() throws Exception {
        if (this.mqMgmtBeanFactory_ == null) {
            try {
                this.mqMgmtBeanFactory_ = new MQMgmtBeanFactory();
                this.mqMgmtBeanFactory_.connect(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword());
            }
            catch (MgmtException me) {
                throw new Exception("Unable to connect to directory service", me);
            }
        }
        return this.mqMgmtBeanFactory_;
    }

    public final MFMgmtBeanFactory getMFBeanFactory() throws Exception {
        if (this.mgmtBeanFactory_ == null) {
            this.mgmtBeanFactory_ = new MFMgmtBeanFactory();
            try {
                this.mgmtBeanFactory_.connect(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword());
            }
            catch (MgmtException me) {
                throw new Exception("Unable to connect to directory service", me);
            }
        }
        return this.mgmtBeanFactory_;
    }

    public final XQMgmtBeanFactory getXQMgmtBeanFactory() throws Exception {
        if (this.xqMgtmFactory_ == null) {
            this.xqMgtmFactory_ = new XQMgmtBeanFactory();
            this.xqMgtmFactory_.connect(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword());
        }
        return this.xqMgtmFactory_;
    }

    public final ESBAdmin getESBAdmin() {
        if (this.esbAdmin_ == null) {
            this.esbAdmin_ = new ESBAdmin(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword(), 10000);
        }
        return this.esbAdmin_;
    }

    public final JMXAdmin getJMXAdmin() {
        if (this.jmxAdmin_ == null) {
            this.jmxAdmin_ = new JMXAdmin(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword(), 10000);
        }
        return this.jmxAdmin_;
    }

    public final DirectoryServiceProxy getDSProxy() throws Exception {
        return this.getJMXAdmin().getDSProxy();
    }

    public final IAgentManagerProxy getAgentManager() throws Exception {
        return this.getJMXAdmin().getAgentManager();
    }

    public final SonicFSFileSystem getSonicFS() throws Exception {
        return this.getJMXAdmin().getSonicFS();
    }

    public final DSArtifactStorage getDSArtifactStorage() throws Exception {
        if (this.dsStore_ == null) {
            try {
                this.dsStore_ = new DSArtifactStorage();
                this.dsStore_.addNotificationListener((IArtifactNotificationListener)new NullArtifactNotificationListener());
                this.dsStore_.connect(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword());
            }
            catch (Exception e) {
                this.dsStore_ = null;
                throw new Exception("Unable to initialize DS Storage", e);
            }
        }
        return this.dsStore_;
    }

    public final Context getInitialContext() throws NamingException {
        if (this.context_ == null) {
            this.getLogger().info((Object)"Resolving Initial Context ...");
            Properties p = new Properties();
            p.setProperty("java.naming.factory.initial", MFContextFactory.class.getName());
            p.setProperty("java.naming.provider.url", this.getUrl());
            p.setProperty("java.naming.security.principal", this.getUser());
            p.setProperty("java.naming.security.credentials", this.getPassword());
            p.setProperty("com.sonicsw.jndi.mfcontext.domain", this.getDomain());
            p.setProperty("com.sonicsw.jndi.mfcontext.idleTimeout", "120000");
            this.context_ = new InitialContext(p);
        }
        return this.context_;
    }

    public final void cleanup() {
        try {
            if (this.dsStore_ != null) {
                this.dsStore_.disconnect();
                this.dsStore_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error disconnecting DS Storage ", (Throwable)e);
        }
        try {
            if (this.mgmtBeanFactory_ != null) {
                this.mgmtBeanFactory_.disconnect();
                this.mgmtBeanFactory_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error disconnecting Mgmt Bean Factory ", (Throwable)e);
        }
        try {
            if (this.xqMgtmFactory_ != null) {
                this.xqMgtmFactory_.disconnect();
                this.xqMgtmFactory_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error disconnecting XQ Mgmt Bean Factory ", (Throwable)e);
        }
        try {
            if (this.mqMgmtBeanFactory_ != null) {
                this.mqMgmtBeanFactory_.disconnect();
                this.mqMgmtBeanFactory_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error disconnecting MQ Mgmt Bean Factory ", (Throwable)e);
        }
        try {
            if (this.context_ != null) {
                this.context_.close();
                this.context_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error closing JNDI context", (Throwable)e);
        }
        try {
            if (this.esbAdmin_ != null) {
                this.esbAdmin_.close();
                this.esbAdmin_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error closing ESB Admin", (Throwable)e);
        }
        try {
            if (this.jmxAdmin_ != null) {
                this.jmxAdmin_.close();
                this.jmxAdmin_ = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error closing JMX Admin", (Throwable)e);
        }
    }

    protected final Logger getLogger() {
        return Logger.getLogger(this.getClass());
    }

    public static boolean pingDomain(String _domainUrl, int _timeout) {
        return JMXAdmin.pingDomain(_domainUrl, _timeout);
    }
}

