/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils.healthcheck;

import com.progress.sonic.utilities.mfutils.JMXAdmin;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import java.util.Iterator;
import java.util.Map;

public class DomainHealthcheck
implements AutoCloseable {
    private JMXAdmin jmxAdmin;

    public DomainHealthcheck(String domain, String url, String user, String password, int timeout) {
        if (!JMXAdmin.pingDomain(url, timeout)) {
            throw new IllegalStateException("Can't ping Domain! URL: " + url);
        }
        this.jmxAdmin = new JMXAdmin(domain, url, user, password, timeout);
    }

    @Override
    public void close() {
        if (this.jmxAdmin != null) {
            this.jmxAdmin.close();
        }
    }

    private IState[] getDomainState() {
        return this.jmxAdmin.getAgentManager().getCollectiveState();
    }

    private void printContainerState(IContainerState containerState) {
        IContainerIdentity containerIdentity = (IContainerIdentity)containerState.getRuntimeIdentity();
        StringBuilder buffer = new StringBuilder("Container Name = ");
        buffer.append(containerIdentity.getContainerName());
        buffer.append(", Host = ");
        buffer.append(containerState.getContainerHost());
        buffer.append(", State = ");
        buffer.append(containerState.getStateString());
        System.out.println(buffer.toString());
        IComponentState[] states = containerState.getComponentStates();
        for (int i = 0; i < states.length; ++i) {
            IComponentState componentState = states[i];
            this.printComponentState(componentState);
        }
        System.out.println();
    }

    private void printComponentState(IComponentState componentState) {
        IComponentIdentity componentIdentity = (IComponentIdentity)componentState.getRuntimeIdentity();
        String componentName = componentIdentity.getComponentName();
        if (componentName.equals("AGENT") || componentName.equals("AGENT MANAGER") || componentName.equals("DIRECTORY SERVICE")) {
            return;
        }
        StringBuilder buffer = new StringBuilder("     Component Name = ");
        buffer.append(componentName);
        buffer.append(", State = ");
        buffer.append(componentState.getStateString());
        System.out.println(buffer.toString());
        this.printSubComponentsState(componentState);
    }

    private void printSubComponentsState(IComponentState componentState) {
        Map subComponents = componentState.getSubComponentStates();
        Iterator i$ = subComponents.values().iterator();
        while (i$.hasNext()) {
            ISubComponentState[] states;
            for (ISubComponentState subcomponentState : states = (ISubComponentState[])i$.next()) {
                StringBuilder buffer = new StringBuilder("          SubComponent Name = ");
                buffer.append(subcomponentState.getSubComponentName());
                buffer.append(", Type = ");
                buffer.append(subcomponentState.getSubComponentType());
                buffer.append(", State = ");
                buffer.append(subcomponentState.getStateString());
                System.out.println(buffer.toString());
            }
        }
    }

    private IContainerState getContainerState(String container) {
        IState[] states = this.getDomainState();
        if (states == null) {
            return null;
        }
        for (int i = 0; i < states.length; ++i) {
            IContainerState containerState = (IContainerState)states[i];
            IContainerIdentity containerIdentity = (IContainerIdentity)containerState.getRuntimeIdentity();
            if (!containerIdentity.getContainerName().equals(container)) continue;
            return containerState;
        }
        return null;
    }

    private boolean isContainerHealthy(IContainerState containerState) {
        if (containerState != null && containerState.getState() == 3) {
            IComponentState[] states = containerState.getComponentStates();
            for (int i = 0; i < states.length; ++i) {
                IComponentState componentState = states[i];
                if (componentState.getState() == 3) {
                    Map subComponents = componentState.getSubComponentStates();
                    Iterator i$ = subComponents.values().iterator();
                    while (i$.hasNext()) {
                        ISubComponentState[] subStates;
                        for (ISubComponentState subcomponentState : subStates = (ISubComponentState[])i$.next()) {
                            if (subcomponentState.getState() == 3) continue;
                            return false;
                        }
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isContainerHealthy(String container) {
        IContainerState containerState = this.getContainerState(container);
        if (containerState == null) {
            return false;
        }
        return this.isContainerHealthy(containerState);
    }

    public boolean isHostHealthy(String host) {
        IState[] states = this.getDomainState();
        if (states == null || states.length == 0) {
            return false;
        }
        for (int i = 0; i < states.length; ++i) {
            IContainerState containerState = (IContainerState)states[i];
            if (!(host != null && containerState.getContainerHost().equals(host) ? !this.isContainerHealthy(containerState) : host == null && !this.isContainerHealthy(containerState))) continue;
            return false;
        }
        return true;
    }

    public boolean isDomainHealthy() {
        return this.isHostHealthy(null);
    }

    public void printContainerState(String container) {
        IContainerState containerState = this.getContainerState(container);
        if (containerState == null) {
            System.out.println("Container " + container + " is not accessible.");
            return;
        }
        this.printContainerState(containerState);
    }

    public void printHostState(String host) {
        IState[] states = this.getDomainState();
        for (int i = 0; i < states.length; ++i) {
            IContainerState containerState = (IContainerState)states[i];
            if (host != null && containerState.getContainerHost().equals(host)) {
                this.printContainerState(containerState);
                continue;
            }
            if (host != null) continue;
            this.printContainerState(containerState);
        }
    }

    public void printDomainState() {
        this.printHostState(null);
    }

    public static void main(String[] args) throws Exception {
        try (DomainHealthcheck domainHealth = new DomainHealthcheck("Domain1", "tcp://localhost:2506", "Administrator", "Administrator", 5000);){
            domainHealth.printDomainState();
            domainHealth.printHostState("dm1");
            domainHealth.printContainerState("ctManagement");
            System.out.println("isContainerHealthy(ctManagement)=" + domainHealth.isContainerHealthy("ctManagement"));
            System.out.println("isContainerHealthy(ctEsb1)=" + domainHealth.isContainerHealthy("ctEsb1"));
            System.out.println("isContainerHealthy(ctBroker1Bak)=" + domainHealth.isContainerHealthy("ctBroker1Bak"));
            System.out.println("isHostHealthy(dm1)=" + domainHealth.isHostHealthy("dm1"));
            System.out.println("isHostHealthy(esb1)=" + domainHealth.isHostHealthy("esb1"));
            System.out.println("isHostHealthy(broker1)=" + domainHealth.isHostHealthy("broker1"));
            System.out.println("isHostHealthy(broker2)=" + domainHealth.isHostHealthy("broker2"));
            System.out.println("isDomainHealthy()=" + domainHealth.isDomainHealthy());
        }
    }
}

