/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils.jndi;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import org.apache.log4j.Logger;

public class JNDIUtil {
    private static Logger logger_ = Logger.getLogger(JNDIUtil.class);

    public static InitialContext createInitialContext(String _initialCFName, String _url, String _user, String _password, String _properties) {
        InitialContext result = null;
        Hashtable<String, String> props = new Hashtable<String, String>();
        logger_.info((Object)"Creating initial context ...");
        logger_.info((Object)("InitialContextFactory = '" + _initialCFName + "'"));
        props.put("java.naming.factory.initial", _initialCFName);
        logger_.info((Object)("ProviderURL = '" + _url + "'"));
        props.put("java.naming.provider.url", _url);
        if (_user != null && _password != null) {
            logger_.info((Object)("User = '" + _user + "'"));
            props.put("java.naming.security.principal", _user);
            logger_.info((Object)("Password = '" + _password + "'"));
            props.put("java.naming.security.credentials", _password);
        }
        if (_properties != null) {
            StringTokenizer sTok = new StringTokenizer(_properties, ";");
            while (sTok.hasMoreTokens()) {
                String pair = sTok.nextToken();
                int pos = pair.indexOf("=");
                if (pos == -1) continue;
                String key = pair.substring(0, pos);
                String value = pair.substring(pos + 1);
                logger_.info((Object)(key + " = '" + value + "'"));
                props.put(key, value);
            }
        }
        try {
            result = new InitialContext(props);
        }
        catch (NamingException ne) {
            logger_.error((Object)("Error resolving Initial context to " + _url));
            ne.printStackTrace();
        }
        logger_.info((Object)"Initial Context created.");
        return result;
    }

    public final void bindObject(Object _obj, String _name, Context _ctx) throws NamingException {
        String name = _name;
        if (!(_obj instanceof Referenceable)) {
            logger_.warn((Object)("Cant bind in JNDI: " + _obj.getClass().getName() + " doesn't implement javax.naming.Referenceable"));
            return;
        }
        logger_.debug((Object)("Binding Object of type " + _obj.getClass().getName() + " to " + name));
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        JNDIUtil.checkContext(_ctx, name);
        try {
            _ctx.bind(name, _obj);
        }
        catch (NamingException ne) {
            logger_.info((Object)"Object exists, rebinding...");
            _ctx.rebind(name, _obj);
        }
    }

    private static void checkContext(Context _ctx, String _name) {
        StringTokenizer sTok = new StringTokenizer(_name, "/");
        if (sTok.countTokens() < 2) {
            return;
        }
        Context subCtx = null;
        String subName = sTok.nextToken();
        try {
            subCtx = (Context)_ctx.lookup(subName);
        }
        catch (NamingException ne) {
            logger_.debug((Object)("Creating subContext " + subName));
            try {
                subCtx = _ctx.createSubcontext(subName);
            }
            catch (NamingException ne2) {}
        }
        catch (ClassCastException cce) {
            logger_.error((Object)("Context " + subName + " already bound and not a Context."));
        }
        JNDIUtil.checkContext(subCtx, _name.substring(subName.length() + 1));
    }
}

