/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils.jndi;

import com.progress.sonic.utilities.mfutils.MFUtils;
import com.progress.sonic.utilities.mfutils.jndi.JNDIUtil;
import commonj.sdo.DataObject;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JNDIBindingTask
extends Task {
    private String jndiObjectsXML_ = null;
    private String domain_ = "Domain1";
    private String url_ = "tcp://localhost:2506";
    private String user_ = "Administrator";
    private String password_ = "Administrator";
    private static final Class[] STRING_PARAMTYPES = new Class[]{String.class};

    public static void main(String[] _args) {
        int index = 0;
        JNDIBindingTask task = new JNDIBindingTask();
        task.setJndiObjectsXML(_args[index]);
        if (_args.length > index++) {
            task.setDomain(_args[index]);
        }
        if (_args.length > index++) {
            task.setUrl(_args[index]);
        }
        if (_args.length > index++) {
            task.setUser(_args[index]);
        }
        if (_args.length > index++) {
            task.setPassword(_args[index]);
        }
        task.execute();
    }

    public final void execute() {
        this.getLogger().info((Object)"Running JNDIBindingTask.....");
        this.getLogger().debug((Object)("using " + this.getDomain() + " " + this.getUrl() + " " + this.getUser() + " " + this.getPassword()));
        MFUtils util = new MFUtils(this.getDomain(), this.getUrl(), this.getUser(), this.getPassword());
        try {
            Context ctx = util.getInitialContext();
            JNDIUtil jndi = new JNDIUtil();
            this.defineTypes();
            DataObject jndiObjects = null;
            XMLDocument xml = null;
            xml = XMLHelper.INSTANCE.load((InputStream)new FileInputStream(this.getJndiObjectsXML()));
            jndiObjects = xml.getRootObject();
            List factories = jndiObjects.getList("ConnectionFactories/ConnectionFactory");
            this.bindObjects(ctx, jndi, factories);
            List destinations = jndiObjects.getList("Destinations/Destination");
            this.bindObjects(ctx, jndi, destinations);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("File not found: " + this.getJndiObjectsXML(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException("Uable to process " + this.getJndiObjectsXML(), (Throwable)e);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new BuildException("Failed to get InitialContext", (Throwable)e);
        }
        finally {
            if (util != null) {
                util.cleanup();
            }
        }
    }

    private void bindObjects(Context _ctx, JNDIUtil _jndi, List _objects) throws NamingException {
        for (int i = 0; i < _objects.size(); ++i) {
            DataObject object = (DataObject)_objects.get(i);
            String lookupName = object.getString("lookupName");
            String className = object.getString("className");
            List properties = object.getList("property");
            Object bean = null;
            try {
                bean = this.createBean(className, properties);
                if (bean != null) {
                    _jndi.bindObject(bean, lookupName, _ctx);
                    continue;
                }
                this.getLogger().error((Object)("Failed to create: " + className));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getLogger().error((Object)("Failed to create: " + lookupName));
            }
        }
    }

    private Object createBean(String _className, List _properties) throws Exception {
        String className = _className;
        if (className.indexOf(".") == -1) {
            className = "progress.message.jclient." + className;
        }
        this.getLogger().info((Object)("Creating object of type: " + className));
        Class<?> objClass = Class.forName(className);
        Object obj = objClass.getConstructor(null).newInstance(null);
        String errMsg = this.setBeanProperties(obj, _properties);
        if (errMsg != null) {
            throw new Exception(errMsg);
        }
        return obj;
    }

    private void defineTypes() throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("xsd/JNDIObjects.xsd");
        XSDHelper.INSTANCE.define(inputStream, null);
        inputStream.close();
    }

    public final String getDomain() {
        return this.domain_;
    }

    public final void setDomain(String _domain) {
        this.domain_ = _domain;
    }

    public final String getUser() {
        return this.user_;
    }

    public final void setUser(String _user) {
        this.user_ = _user;
    }

    public final String getPassword() {
        return this.password_;
    }

    public final void setPassword(String _password) {
        this.password_ = _password;
    }

    public final String getUrl() {
        return this.url_;
    }

    public final void setUrl(String _url) {
        this.url_ = _url;
    }

    public final String getJndiObjectsXML() {
        return this.jndiObjectsXML_;
    }

    public final void setJndiObjectsXML(String _jndiObjectsXML) {
        this.jndiObjectsXML_ = _jndiObjectsXML;
    }

    private String setBeanProperties(Object _bean, List _properties) {
        String props = "";
        this.getLogger().info((Object)"Properties:");
        for (int i = 0; i < _properties.size(); ++i) {
            DataObject prop = (DataObject)_properties.get(i);
            if (props.length() > 0) {
                props = props + "|";
            }
            String name = prop.getString("name");
            String value = prop.getString(0);
            this.getLogger().info((Object)(name + ": " + value));
            props = props + name + "=" + value;
        }
        Class<?> beanClass = _bean.getClass();
        HashMap<String, Method> beanSetterMethods = new HashMap<String, Method>();
        Method[] allMethods = beanClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            String name = allMethods[i].getName();
            if (!name.startsWith("set") || allMethods[i].getParameterTypes().length != 1) continue;
            beanSetterMethods.put(name, allMethods[i]);
        }
        StringTokenizer st = new StringTokenizer(props, "|");
        while (st.hasMoreTokens()) {
            StringTokenizer nvp = new StringTokenizer(st.nextToken(), "=");
            String propertyName = nvp.nextToken();
            if (!nvp.hasMoreElements()) {
                return "Failed: attribute \"" + propertyName + "\" has no value specified";
            }
            String propertyValue = nvp.nextToken();
            Method method = (Method)beanSetterMethods.get("set" + propertyName);
            if (method == null) {
                return "Failed: attribute \"" + propertyName + "\" is not valid";
            }
            Class<?> propertyType = method.getParameterTypes()[0];
            Comparable<Boolean> propertyValueObject = null;
            try {
                if (propertyType.getName().equals("boolean")) {
                    propertyValueObject = new Boolean(propertyValue);
                } else if (propertyType.getName().equals("int")) {
                    propertyValueObject = new Integer(propertyValue);
                } else if (propertyType.getName().equals("long")) {
                    propertyValueObject = new Long(propertyValue);
                } else if (propertyType.getName().equals("double")) {
                    propertyValueObject = new Double(propertyValue);
                } else if (propertyType.getName().equals("short")) {
                    propertyValueObject = new Short(propertyValue);
                } else if (propertyType.getName().equals("float")) {
                    propertyValueObject = new Float(propertyValue);
                } else {
                    Constructor<?> constructor = propertyType.getConstructor(STRING_PARAMTYPES);
                    propertyValueObject = constructor.newInstance(propertyValue);
                }
                method.invoke(_bean, propertyValueObject);
            }
            catch (Exception e) {
                return "Failed: attribute \"" + propertyName + "\" could not be set: " + e.getMessage();
            }
        }
        return null;
    }

    protected final Logger getLogger() {
        return Logger.getLogger(((Object)((Object)this)).getClass());
    }
}

