/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.esb.admin;

import com.progress.sonic.utilities.mfutils.MFUtils;
import com.progress.sonic.utilities.mfutils.NullArtifactNotificationListener;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.traversal.AbstractTraverser;
import com.sonicsw.deploy.traversal.TraverserContext;
import com.sonicsw.deploy.traversal.TraverserFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class XarAnalyzer {
    private IArtifactStorage as = null;

    public XarAnalyzer(IArtifactStorage _as) {
        this.as = _as;
    }

    public XarAnalyzer(File _f) {
        if (_f.exists()) {
            if (_f.isDirectory()) {
                try {
                    FileArtifactStorage fas = new FileArtifactStorage();
                    fas.addNotificationListener((IArtifactNotificationListener)new NullArtifactNotificationListener());
                    fas.setRoot(_f.getAbsolutePath());
                    this.as = fas;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    XarAnalyzer.doUnzipAction(_f.getAbsolutePath(), "target" + File.separatorChar + "unzip" + File.separatorChar + _f.getName());
                    FileArtifactStorage fas = new FileArtifactStorage();
                    fas.addNotificationListener((IArtifactNotificationListener)new NullArtifactNotificationListener());
                    fas.setRoot("target" + File.separatorChar + "unzip" + File.separatorChar + _f.getName());
                    this.as = fas;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public XarAnalyzer(String _fileName) {
        this(new File(_fileName));
    }

    public XarAnalyzer(MFUtils _utils) throws Exception {
        this.as = _utils.getDSArtifactStorage();
    }

    public final IArtifactStorage getStorage() throws Exception {
        if (this.as == null) {
            throw new IllegalStateException("Arrtifact Storage as not been initialized correctly.");
        }
        return this.as;
    }

    public final byte[] getContent(IArtifact _a) throws Exception {
        return this.getStorage().getContentsAsBytes(_a);
    }

    public final List<IArtifact> getAllArtifacts() {
        IArtifactTraverser traverser = TraverserFactory.createListAllTraverser();
        return this.getArtifacts(traverser);
    }

    public final List<IArtifact> getArtifacts(IArtifact _a) {
        List<IArtifact> result = new ArrayList<IArtifact>();
        try {
            result = this.getArtifacts(TraverserFactory.createTraverser((IArtifact)_a));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public final List<IArtifact> getArtifacts(IArtifactTraverser _traverser) {
        ArrayList<IArtifactTraverser> t = new ArrayList<IArtifactTraverser>(1);
        t.add(_traverser);
        return this.getArtifacts(t);
    }

    public final List<IArtifact> getArtifacts(List<IArtifactTraverser> _traversers) {
        List<IArtifact> result = new ArrayList<IArtifact>();
        try {
            TraverserContext ctxt = new TraverserContext(this.getStorage(), new IArtifact[0]);
            for (IArtifactTraverser traverser : _traversers) {
                ((AbstractTraverser)traverser)._traverse((IArtifactTraversalContext)ctxt);
            }
            result = Arrays.asList(ctxt.completeTraversal());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void doUnzipAction(String _filename, String _unzipDir) {
        int bufferSize = 1024;
        FileOutputStream dest = null;
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(new File(_filename))));
            new File(_unzipDir).mkdirs();
            while ((entry = zis.getNextEntry()) != null) {
                byte[] data = new byte[1024];
                String targetFile = _unzipDir + "/" + entry.getName();
                XarAnalyzer.createSubDirectory(_unzipDir, entry);
                if (!entry.isDirectory()) {
                    int count;
                    dest = new FileOutputStream(targetFile);
                    while ((count = zis.read(data, 0, 1024)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                }
                dest = null;
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void createSubDirectory(String _unzipDir, ZipEntry _entry) {
        String fileDir;
        String name = _entry.getName();
        if (name.indexOf("\\") > 0) {
            fileDir = name.substring(0, name.lastIndexOf("\\"));
        } else if (name.indexOf("/") > 0) {
            fileDir = name.substring(0, name.lastIndexOf("/"));
        } else {
            return;
        }
        File newdir = new File(_unzipDir + File.separator + fileDir);
        if (!newdir.exists()) {
            newdir.mkdirs();
        }
    }
}

