/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils.healthcheck;

import com.progress.sonic.utilities.mfutils.healthcheck.DomainHealthcheck;

public class HealthcheckCLI {
    private static void printUsage() {
        System.out.println("Sonic Domain Healthcheck Tool");
        System.out.println();
        System.out.println("Usage: HealthcheckCLI <Domain> <URL> <User> <Password> <Timeout> [Host]");
        System.out.println();
        System.out.println("Example: HealthcheckCLI Domain1 tcp://localhost:2506 Administrator Administrator 10000");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            HealthcheckCLI.printUsage();
            System.exit(-2);
        }
        String domain = args[0];
        String url = args[1];
        String user = args[2];
        String password = args[3];
        int timeout = Integer.parseInt(args[4]);
        String host = args.length > 5 ? args[5] : null;
        int exitCode = -1;
        try (DomainHealthcheck domainHealth = new DomainHealthcheck(domain, url, user, password, timeout);){
            domainHealth.printHostState(host);
            if (domainHealth.isHostHealthy(host)) {
                exitCode = 0;
            }
        }
        System.exit(exitCode);
    }
}

