/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.esb.admin;

import com.progress.sonic.utilities.esb.admin.ESBAdmin;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IServiceConfig;
import com.sonicsw.esb.mgmtapi.config.IServiceConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IServiceTypeConfig;
import java.io.File;

public class ServiceAdmin
extends ESBAdmin {
    protected IServiceConfigAPI serviceApi;

    public ServiceAdmin(String _domainName, String _domainUrl, String _username, String _password, int _timeout) {
        super(_domainName, _domainUrl, _username, _password, _timeout);
        this.serviceApi = this.esbApi.getServiceConfigAPI();
    }

    public ServiceAdmin(ESBAPI _esbapi) {
        super(_esbapi);
        this.serviceApi = this.esbApi.getServiceConfigAPI();
    }

    public String exportServiceConfig(String _serviceConfigName) {
        return this.serviceApi.exportService(_serviceConfigName);
    }

    public String getServiceTypeOfServiceConfig(String _serviceConfigName) {
        return this.serviceApi.getServiceConfig(_serviceConfigName).getServiceTypeConfig().getName();
    }

    public void importServiceConfig(File _serviceConfigFile, boolean _overwrite) {
        if (_overwrite || !this.isServiceConfigExisting(_serviceConfigFile.getName().replace(".xml", ""))) {
            try {
                String serviceConfig = new String(FileUtils.readFile((File)_serviceConfigFile), "UTF-8");
                this.serviceApi.importService(serviceConfig, _overwrite);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void importServiceType(File _serviceTypeFile, File _serviceTypeProperties, boolean _overwrite) {
        if (_overwrite || !this.isServiceTypeExisting(_serviceTypeFile.getName().replace(".xml", ""))) {
            try {
                String serviceType = new String(FileUtils.readFile((File)_serviceTypeFile), "UTF-8");
                String serviceProperties = new String(FileUtils.readFile((File)_serviceTypeProperties), "UTF-8");
                this.serviceApi.importServiceType(serviceType, _overwrite);
                this.serviceApi.importServiceProperties(_serviceTypeProperties.getName().replace(".properties", ""), serviceProperties);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IServiceConfig createServiceTypeConfig(String _serviceConfigName, String _serviceTypeName, IEndpointConfig _endpoint, boolean _overwrite) {
        if (this.isServiceConfigExisting(_serviceConfigName)) {
            if (_overwrite) {
                this.serviceApi.deleteServiceConfig(_serviceConfigName);
            } else {
                return this.serviceApi.getServiceConfig(_serviceConfigName);
            }
        }
        IServiceConfig service = this.serviceApi.createServiceConfig(_serviceConfigName, _serviceTypeName);
        service.setEntryEndpointConfig(_endpoint);
        this.serviceApi.saveService(service);
        return service;
    }

    public boolean isServiceConfigExisting(String _serviceConfigName) {
        IServiceConfig pc = this.serviceApi.getServiceConfig(_serviceConfigName);
        return pc != null;
    }

    public boolean isServiceTypeExisting(String _serviceTypeName) {
        IServiceTypeConfig pc = this.serviceApi.getServiceType(_serviceTypeName);
        return pc != null;
    }
}

