/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils;

import com.progress.sonic.utilities.mfutils.CommitHolder;
import com.progress.sonic.utilities.mfutils.Filter;
import com.progress.sonic.utilities.mfutils.IVisitor;
import com.progress.sonic.utilities.mfutils.MFUtils;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeanList
extends ArrayList {
    private static final long serialVersionUID = 3732602001278676823L;

    public BeanList() {
    }

    public BeanList(MFUtils _mfUtils, List _beanNames) {
        this(_mfUtils, _beanNames, null);
    }

    public BeanList(MFUtils _mfUtils, List _beanNames, Filter _filter) {
        try {
            this.createList(_mfUtils, _beanNames, _filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void accept(IVisitor _visitor) {
        this.run(_visitor, new CommitHolder());
    }

    public final void accept(IVisitor _visitor, int _commitThreshold) {
        this.run(_visitor, new CommitHolder(_commitThreshold));
    }

    protected final void run(IVisitor _visitor, CommitHolder _ch) {
        for (IMgmtBeanBase bean : this) {
            if (!_visitor.visit(bean)) continue;
            _ch.addCommitFactory(bean.getMgmtBeanFactory());
        }
        _ch.commitAll();
    }

    protected final void createList(MFUtils _mfUtils, List _beanNames, Filter _filter) throws Exception {
        for (String key : _beanNames) {
            try {
                IMgmtBeanBase bean = this.getBean(_mfUtils, key);
                if (bean == null || _filter != null && !_filter.match(bean)) continue;
                this.add(bean);
            }
            catch (MgmtException me) {
                this.getLogger().warn("Error retrieving Bean " + key);
                if (!this.getLogger().isDebugEnabled()) continue;
                me.printStackTrace();
            }
        }
    }

    protected final IMgmtBeanBase getBean(MFUtils _mfUtils, String _beanName) throws Exception {
        IMgmtBeanBase result = null;
        MgmtBeanFactory[] factories = new MgmtBeanFactory[]{_mfUtils.getMQBeanFactory(), _mfUtils.getXQMgmtBeanFactory()};
        String[] extensions = new String[]{"", "/_Default", "/_MFDomainDescriptor", "/_MQPolicyDescriptor"};
        for (int i = 0; i < factories.length && result == null; ++i) {
            for (int j = 0; j < extensions.length && result == null; ++j) {
                try {
                    result = factories[i].getBean(_beanName + extensions[j]);
                    continue;
                }
                catch (MgmtException mgmtException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            this.getLogger().error("NOT FOUND : " + _beanName);
        }
        return result;
    }

    protected final Logger getLogger() {
        return LogManager.getLogger(this.getClass());
    }
}

