/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mfutils;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mf.mgmtapi.runtime.MFProxyFactory;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class JMXAdmin {
    public static final String AGENT_MANAGER = "AGENT MANAGER";
    public static final String AGENT = "AGENT";
    public static final String DIRECTORY_SERVICE = "DIRECTORY SERVICE";
    private final String domain_;
    private final String url_;
    private final String user_;
    private final String pwd_;
    private final int timeout_;
    private JMSConnectorClient connector_ = null;

    public final String getUrl() {
        return this.url_;
    }

    public final String getDomain() {
        return this.domain_;
    }

    public final String getUser() {
        return this.user_;
    }

    public final String getPassword() {
        return this.pwd_;
    }

    public JMXAdmin(String _domain, String _url, String _user, String _password, int _timeout) {
        this.domain_ = _domain;
        this.url_ = _url;
        this.user_ = _user;
        this.pwd_ = _password;
        this.timeout_ = _timeout;
    }

    public final JMSConnectorClient getConnectorClient() {
        if (this.connector_ == null) {
            Hashtable<String, String> env = this.createConnectorMap(this.getUrl(), this.getUser(), this.getPassword());
            this.connector_ = new JMSConnectorClient();
            this.connector_.setRequestTimeout((long)this.timeout_);
            this.connector_.connect(new JMSConnectorAddress(env), (long)this.timeout_);
        }
        return this.connector_;
    }

    public final DirectoryServiceProxy getDSProxy() {
        DirectoryServiceProxy dsProxy_ = new DirectoryServiceProxy((IRemoteMBeanServer)this.getConnectorClient(), this.createObjectName(DIRECTORY_SERVICE, DIRECTORY_SERVICE));
        return dsProxy_;
    }

    public final IAgentProxy getAgentProxy(String container) {
        ObjectName jmxName = this.createObjectName(container, AGENT);
        return MFProxyFactory.createAgentProxy((JMSConnectorClient)this.getConnectorClient(), (ObjectName)jmxName);
    }

    public final SonicFSFileSystem getSonicFS() {
        return new SonicFSFileSystem((IDirectoryFileSystemService)this.getDSProxy(), this.getUser());
    }

    public final IAgentManagerProxy getAgentManager() {
        IAgentManagerProxy agentManager_ = MFProxyFactory.createAgentManagerProxy((JMSConnectorClient)this.getConnectorClient(), (ObjectName)this.createObjectName(AGENT_MANAGER, AGENT_MANAGER));
        return agentManager_;
    }

    public final void close() {
        if (this.connector_ != null) {
            this.connector_.disconnect();
            this.connector_ = null;
        }
    }

    private Hashtable<String, String> createConnectorMap(String url, String user, String password) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("ConnectionURLs", url);
        if (user != null && user.length() > 0) {
            map.put("DefaultUser", user);
        }
        if (password != null && password.length() > 0) {
            map.put("DefaultPassword", password);
        }
        return map;
    }

    private ObjectName createObjectName(String container, String id) {
        try {
            return new ObjectName(this.createCanonicalName(container, id));
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String createCanonicalName(String container, String id) {
        StringBuilder buffer = new StringBuilder(this.getDomain());
        buffer.append('.').append(container).append(':');
        buffer.append("ID=").append(id);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingDomain(String _domainUrl, int _timeout) {
        String[] urls = _domainUrl.split(",");
        Socket sock = new Socket();
        try {
            sock.bind(null);
            for (String url : urls) {
                String hostport = url.replace("tcp://", "");
                String hostname = hostport.split(":")[0];
                int port = Integer.parseInt(hostport.split(":")[1]);
                sock.connect(new InetSocketAddress(hostname, port), _timeout);
                if (!sock.isConnected()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }
}

