/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.mq.admin;

import com.progress.sonic.utilities.mq.admin.MQAdmin;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mq.mgmtapi.config.IBrokerBean;
import com.sonicsw.mq.mgmtapi.config.IClusterBean;
import com.sonicsw.mq.mgmtapi.config.IQueuesBean;
import java.util.List;

public class QueueAdmin
extends MQAdmin {
    private static final int DEFAULT_QUEUE_SAVE_THREASHOLD = 1536;
    private static final int DEFAULT_QUEUE_MAX_SIZE = 1000;
    private static final boolean DEFAULT_QUEUE_GLOBAL = true;
    private static final boolean DEFAULT_QUEUE_READ_EXCLUSIVE = false;

    public QueueAdmin(String _domainName, String _domainUrl, String _username, String _password, int _timeout) {
        super(_domainName, _domainUrl, _username, _password, _timeout);
    }

    public void createQueue(String _brokerOrClusterPath, String _queueName, Integer _saveThreshold, Integer _maxSize, Boolean _global, Boolean _readExclusive) throws MgmtException {
        IQueuesBean.IQueueAttributes queue;
        IQueuesBean.IQueuesSetType queues;
        try {
            IBrokerBean broker = this.domain.getBrokerBean(_brokerOrClusterPath);
            queues = broker.getQueuesBean().getQueues();
        }
        catch (MgmtException e1) {
            try {
                IClusterBean cluster = this.domain.getClusterBean(_brokerOrClusterPath);
                queues = cluster.getQueuesBean().getQueues();
            }
            catch (MgmtException e) {
                throw new MgmtException("Could not find Broker or Cluster at: " + _brokerOrClusterPath);
            }
        }
        try {
            queue = queues.getQueue(_queueName);
        }
        catch (MgmtException e) {
            queue = queues.createQueue();
            queue.setQueueName(_queueName);
            queue.setQueueSaveThreshold(_saveThreshold != null ? _saveThreshold : 1536);
            queue.setQueueMaxSize(_maxSize != null ? _maxSize : 1000);
            queue.setGlobal(_global != null ? _global : true);
            queue.setReadExclusive(_readExclusive != null ? _readExclusive : false);
            queues.addQueue(_queueName, queue);
            this.domain.commit();
        }
    }

    public List<String> getQueues(String _brokerOrClusterPath) throws MgmtException {
        IQueuesBean.IQueuesSetType queues;
        try {
            IBrokerBean broker = this.domain.getBrokerBean(_brokerOrClusterPath);
            queues = broker.getQueuesBean().getQueues();
        }
        catch (MgmtException e1) {
            IClusterBean cluster = this.domain.getClusterBean(_brokerOrClusterPath);
            queues = cluster.getQueuesBean().getQueues();
        }
        return queues.getKeyNames();
    }
}

