/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.esb.admin;

import com.progress.sonic.utilities.esb.admin.ESBAdmin;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.config.IConnectionConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IJMSQueueEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IJMSTopicEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IQos;
import java.io.File;

public class EndpointAdmin
extends ESBAdmin {
    protected IEndpointConfigAPI endpointApi;
    public static final String DEFAULT_CONNECTION = "jms_defaultConnection";
    public static final int DEFAULT_PRIORITY = 4;

    public EndpointAdmin(String _domainName, String _domainUrl, String _username, String _password, int _timeout) {
        super(_domainName, _domainUrl, _username, _password, _timeout);
        this.endpointApi = this.esbApi.getEndpointConfigAPI();
    }

    public EndpointAdmin(ESBAPI _esbapi) {
        super(_esbapi);
        this.endpointApi = this.esbApi.getEndpointConfigAPI();
    }

    public IEndpointConfig createTopicEndpoint(String _endpointName) {
        return this.createEndpoint(_endpointName, DEFAULT_CONNECTION, IQos.BEST_EFFORT, IEndpointConfig.JMS_TOPIC, false, _endpointName, 4, false);
    }

    public IEndpointConfig createQueueEndpoint(String _endpointName) {
        return this.createEndpoint(_endpointName, DEFAULT_CONNECTION, IQos.BEST_EFFORT, IEndpointConfig.JMS_QUEUE, false, _endpointName, 4, false);
    }

    public IEndpointConfig createEndpoint(String _endpointName, String _endpointConnection, IQos.QOSLevel _qos, IEndpointConfig.EndpointDestinationType _destType, boolean _concurrentDurable, String _destinationName, int _priority, boolean _overwrite) {
        if (this.isEndpointExisting(_endpointName)) {
            if (_overwrite) {
                this.endpointApi.deleteEndpoint(_endpointName);
            } else {
                return this.getEndpoint(_endpointName);
            }
        }
        IEndpointConfig epc = this.endpointApi.createEndpoint(_endpointName);
        IConnectionConfig jmsConnection = this.endpointApi.getConnectionConfig(_endpointConnection);
        epc.setConnectionConfig(jmsConnection);
        epc.setDestinationType(_destType);
        if (_destType == IEndpointConfig.JMS_TOPIC) {
            IJMSTopicEndpointConfig endpointTopic = (IJMSTopicEndpointConfig)epc.getAdapter();
            endpointTopic.setConcurrentDurable(_concurrentDurable);
            endpointTopic.setDestinationName(_destinationName);
            endpointTopic.setPriority(_priority);
        } else {
            IJMSQueueEndpointConfig endpointQueue = (IJMSQueueEndpointConfig)epc.getAdapter();
            endpointQueue.setDestinationName(_destinationName);
            endpointQueue.setPriority(_priority);
        }
        this.endpointApi.saveEndpoint(epc);
        return epc;
    }

    public void importEndpoint(File _endpointFile, boolean _overwrite) {
        if (_overwrite || !this.isEndpointExisting(_endpointFile.getName().replace(".xml", ""))) {
            try {
                String endpoint = new String(FileUtils.readFile((File)_endpointFile), "UTF-8");
                this.endpointApi.importEndpoint(endpoint, _overwrite);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IEndpointConfig getEndpoint(String _endpointName) {
        return this.endpointApi.getEndpoint(_endpointName);
    }

    public boolean isEndpointExisting(String _endpointName) {
        IEndpointConfig epc = this.endpointApi.getEndpoint(_endpointName);
        return epc != null;
    }

    public void importConnection(File _connectionFile, boolean _overwrite) {
        if (_overwrite || !this.isConnectionExisting(_connectionFile.getName().replace(".xml", ""))) {
            try {
                String connection = new String(FileUtils.readFile((File)_connectionFile), "UTF-8");
                this.endpointApi.importConnection(connection, _overwrite);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isConnectionExisting(String _connectionName) {
        IConnectionConfig cc = this.endpointApi.getConnectionConfig(_connectionName);
        return cc != null;
    }
}

